/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der.ASN1Object;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der.ASN1Type;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.Arrays;

public class DERParser
extends FilterInputStream {
    public static final int MAX_DER_VALUE_LENGTH = 65534;
    private final byte[] lenBytes = new byte[4];

    public DERParser(byte ... bytes) {
        this(bytes, 0, NumberUtils.length(bytes));
    }

    public DERParser(byte[] bytes, int offset, int len) {
        this(new ByteArrayInputStream(bytes, offset, len));
    }

    public DERParser(InputStream s) {
        super(s);
    }

    public int readLength() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new StreamCorruptedException("Invalid DER: length missing");
        }
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        int num = i & 0x7F;
        if (i >= 255 || num > this.lenBytes.length) {
            throw new StreamCorruptedException("Invalid DER: length field too big: " + i);
        }
        Arrays.fill(this.lenBytes, (byte)0);
        int n = this.read(this.lenBytes, 4 - num, num);
        if (n < num) {
            throw new StreamCorruptedException("Invalid DER: length data too short: expected=" + num + ", actual=" + n);
        }
        long len = BufferUtils.getUInt(this.lenBytes);
        if (len < 127L) {
            throw new StreamCorruptedException("Invalid DER: length not in shortest form: " + len);
        }
        if (len > 65534L) {
            throw new StreamCorruptedException("Invalid DER: data length too big: " + len + " (max=" + 65534 + ")");
        }
        return (int)len;
    }

    public ASN1Object readObject() throws IOException {
        int tag = this.read();
        if (tag == -1) {
            return null;
        }
        ASN1Type objType = ASN1Type.fromDERValue(tag);
        if (objType == ASN1Type.NULL) {
            return new ASN1Object((byte)tag, 0, GenericUtils.EMPTY_BYTE_ARRAY);
        }
        int length = this.readLength();
        byte[] value = new byte[length];
        int n = this.read(value);
        if (n < length) {
            throw new StreamCorruptedException("Invalid DER: stream too short, missing value: read " + n + " out of required " + length);
        }
        return new ASN1Object((byte)tag, length, value);
    }

    public BigInteger readBigInteger() throws IOException {
        int type = this.read();
        if (type != 2) {
            throw new StreamCorruptedException("Invalid DER: data type is not an INTEGER: 0x" + Integer.toHexString(type));
        }
        int len = this.readLength();
        byte[] value = new byte[len];
        int n = this.read(value);
        if (n < len) {
            throw new StreamCorruptedException("Invalid DER: stream too short, missing value: read " + n + " out of required " + len);
        }
        return new BigInteger(value);
    }
}

