/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.cipher;

import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.Cipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.mac.Mac;
import io.jenkins.cli.shaded.org.apache.sshd.common.mac.Poly1305Mac;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;

public class ChaCha20Cipher
implements Cipher {
    protected final ChaChaEngine headerEngine = new ChaChaEngine();
    protected final ChaChaEngine bodyEngine = new ChaChaEngine();
    protected final Mac mac = new Poly1305Mac();
    protected Cipher.Mode mode;

    @Override
    public String getAlgorithm() {
        return "ChaCha20";
    }

    @Override
    public void init(Cipher.Mode mode, byte[] key, byte[] iv) throws Exception {
        this.mode = mode;
        this.bodyEngine.initKey(Arrays.copyOfRange(key, 0, 32));
        this.bodyEngine.initNonce(iv);
        this.mac.init(this.bodyEngine.polyKey());
        this.headerEngine.initKey(Arrays.copyOfRange(key, 32, 64));
        this.headerEngine.initNonce(iv);
        this.headerEngine.initCounter(0L);
    }

    @Override
    public void updateAAD(byte[] data, int offset, int length) throws Exception {
        ValidateUtils.checkState(this.mode != null, "Cipher not initialized");
        ValidateUtils.checkTrue(length == 4, "AAD only supported for encrypted packet length");
        if (this.mode == Cipher.Mode.Decrypt) {
            this.mac.update(data, offset, length);
        }
        this.headerEngine.crypt(data, offset, length, data, offset);
        if (this.mode == Cipher.Mode.Encrypt) {
            this.mac.update(data, offset, length);
        }
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) throws Exception {
        ValidateUtils.checkState(this.mode != null, "Cipher not initialized");
        if (this.mode == Cipher.Mode.Decrypt) {
            this.mac.update(input, inputOffset, inputLen);
            byte[] actual = this.mac.doFinal();
            if (!Mac.equals(input, inputOffset + inputLen, actual, 0, actual.length)) {
                throw new AEADBadTagException("Tag mismatch");
            }
        }
        this.bodyEngine.crypt(input, inputOffset, inputLen, input, inputOffset);
        if (this.mode == Cipher.Mode.Encrypt) {
            this.mac.update(input, inputOffset, inputLen);
            this.mac.doFinal(input, inputOffset + inputLen);
        }
        this.headerEngine.advanceNonce();
        this.headerEngine.initCounter(0L);
        this.bodyEngine.advanceNonce();
        this.mac.init(this.bodyEngine.polyKey());
    }

    @Override
    public String getTransformation() {
        return "ChaCha20";
    }

    @Override
    public int getIVSize() {
        return 8;
    }

    @Override
    public int getAuthenticationTagSize() {
        return 16;
    }

    @Override
    public int getCipherBlockSize() {
        return 8;
    }

    @Override
    public int getKdfSize() {
        return 64;
    }

    @Override
    public int getKeySize() {
        return 256;
    }

    protected static class ChaChaEngine {
        private static final int BLOCK_BYTES = 64;
        private static final int BLOCK_INTS = 16;
        private static final int KEY_OFFSET = 4;
        private static final int KEY_BYTES = 32;
        private static final int KEY_INTS = 8;
        private static final int COUNTER_OFFSET = 12;
        private static final int NONCE_OFFSET = 14;
        private static final int NONCE_BYTES = 8;
        private static final int NONCE_INTS = 2;
        private static final int[] ENGINE_STATE_HEADER = ChaChaEngine.unpackSigmaString("expand 32-byte k".getBytes(StandardCharsets.US_ASCII));
        protected final int[] x = new int[16];
        protected final int[] engineState = new int[16];
        protected final byte[] nonce = new byte[8];
        protected long initialNonce;

        protected ChaChaEngine() {
            System.arraycopy(ENGINE_STATE_HEADER, 0, this.engineState, 0, 4);
        }

        protected void initKey(byte[] key) {
            ChaChaEngine.unpackIntsLE(key, 0, 8, this.engineState, 4);
        }

        protected void initNonce(byte[] nonce) {
            this.initialNonce = BufferUtils.getLong(nonce, 0, NumberUtils.length(nonce));
            ChaChaEngine.unpackIntsLE(nonce, 0, 2, this.engineState, 14);
            System.arraycopy(nonce, 0, this.nonce, 0, 8);
        }

        protected void advanceNonce() {
            long counter = BufferUtils.getLong(this.nonce, 0, 8) + 1L;
            ValidateUtils.checkState(counter != this.initialNonce, "Packet sequence number cannot be reused with the same key");
            BufferUtils.putLong(counter, this.nonce, 0, 8);
            ChaChaEngine.unpackIntsLE(this.nonce, 0, 2, this.engineState, 14);
        }

        protected void initCounter(long counter) {
            this.engineState[12] = (int)counter;
            this.engineState[13] = (int)(counter >>> 32);
        }

        protected void crypt(byte[] in, int offset, int length, byte[] out, int outOffset) {
            while (length > 0) {
                System.arraycopy(this.engineState, 0, this.x, 0, 16);
                ChaChaEngine.permute(this.x);
                int want = Math.min(64, length);
                int i = 0;
                int j = 0;
                while (i < want) {
                    int keyStream = this.engineState[j] + this.x[j];
                    int take = Math.min(4, length);
                    int input = ChaChaEngine.unpackIntLE(in, offset, take);
                    int output = keyStream ^ input;
                    ChaChaEngine.packIntLE(output, out, outOffset, take);
                    offset += take;
                    outOffset += take;
                    length -= take;
                    i += 4;
                    ++j;
                }
                this.engineState[12] = this.engineState[12] + 1;
                int lo = this.engineState[12];
                if (lo != 0) continue;
                this.engineState[13] = this.engineState[13] + 1;
            }
        }

        protected byte[] polyKey() {
            byte[] block = new byte[32];
            this.initCounter(0L);
            this.crypt(block, 0, block.length, block, 0);
            this.initCounter(1L);
            return block;
        }

        protected static void permute(int[] state) {
            for (int i = 0; i < 10; ++i) {
                ChaChaEngine.columnRound(state);
                ChaChaEngine.diagonalRound(state);
            }
        }

        protected static void columnRound(int[] state) {
            ChaChaEngine.quarterRound(state, 0, 4, 8, 12);
            ChaChaEngine.quarterRound(state, 1, 5, 9, 13);
            ChaChaEngine.quarterRound(state, 2, 6, 10, 14);
            ChaChaEngine.quarterRound(state, 3, 7, 11, 15);
        }

        protected static void diagonalRound(int[] state) {
            ChaChaEngine.quarterRound(state, 0, 5, 10, 15);
            ChaChaEngine.quarterRound(state, 1, 6, 11, 12);
            ChaChaEngine.quarterRound(state, 2, 7, 8, 13);
            ChaChaEngine.quarterRound(state, 3, 4, 9, 14);
        }

        protected static void quarterRound(int[] state, int a, int b, int c, int d) {
            int n = a;
            state[n] = state[n] + state[b];
            state[d] = Integer.rotateLeft(state[d] ^ state[a], 16);
            int n2 = c;
            state[n2] = state[n2] + state[d];
            state[b] = Integer.rotateLeft(state[b] ^ state[c], 12);
            int n3 = a;
            state[n3] = state[n3] + state[b];
            state[d] = Integer.rotateLeft(state[d] ^ state[a], 8);
            int n4 = c;
            state[n4] = state[n4] + state[d];
            state[b] = Integer.rotateLeft(state[b] ^ state[c], 7);
        }

        private static int unpackIntLE(byte[] buf, int off) {
            return ChaChaEngine.unpackIntLE(buf, off, 4);
        }

        private static int unpackIntLE(byte[] buf, int off, int len) {
            int ret = 0;
            for (int i = 0; i < len; ++i) {
                ret |= Byte.toUnsignedInt(buf[off + i]) << i * 8;
            }
            return ret;
        }

        private static void unpackIntsLE(byte[] buf, int off, int nrInts, int[] dst, int dstOff) {
            for (int i = 0; i < nrInts; ++i) {
                dst[dstOff++] = ChaChaEngine.unpackIntLE(buf, off);
                off += 4;
            }
        }

        private static int[] unpackSigmaString(byte[] buf) {
            int[] values = new int[4];
            ChaChaEngine.unpackIntsLE(buf, 0, 4, values, 0);
            return values;
        }

        private static void packIntLE(int value, byte[] dst, int off, int len) {
            for (int i = 0; i < len; ++i) {
                dst[off + i] = (byte)(value >>> i * 8);
            }
        }
    }
}

