/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@FunctionalInterface
public interface KeyPairResourceLoader {
    public static final KeyPairResourceLoader EMPTY = (resourceKey, passwordProvider, lines) -> Collections.emptyList();

    default public Collection<KeyPair> loadKeyPairs(Path path, FilePasswordProvider passwordProvider, OpenOption ... options) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(path, passwordProvider, StandardCharsets.UTF_8, options);
    }

    default public Collection<KeyPair> loadKeyPairs(Path path, FilePasswordProvider passwordProvider, Charset cs, OpenOption ... options) throws IOException, GeneralSecurityException {
        try (InputStream stream = Files.newInputStream(path, options);){
            Collection<KeyPair> collection = this.loadKeyPairs(path.toString(), passwordProvider, stream, cs);
            return collection;
        }
    }

    default public Collection<KeyPair> loadKeyPairs(URL url, FilePasswordProvider passwordProvider) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(url, passwordProvider, StandardCharsets.UTF_8);
    }

    default public Collection<KeyPair> loadKeyPairs(URL url, FilePasswordProvider passwordProvider, Charset cs) throws IOException, GeneralSecurityException {
        try (InputStream stream = Objects.requireNonNull(url, "No URL").openStream();){
            Collection<KeyPair> collection = this.loadKeyPairs(url.toExternalForm(), passwordProvider, stream, cs);
            return collection;
        }
    }

    default public Collection<KeyPair> loadKeyPairs(String resourceKey, FilePasswordProvider passwordProvider, String data) throws IOException, GeneralSecurityException {
        try (StringReader reader = new StringReader(data == null ? "" : data);){
            Collection<KeyPair> collection = this.loadKeyPairs(resourceKey, passwordProvider, reader);
            return collection;
        }
    }

    default public Collection<KeyPair> loadKeyPairs(String resourceKey, FilePasswordProvider passwordProvider, InputStream stream) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(resourceKey, passwordProvider, stream, StandardCharsets.UTF_8);
    }

    default public Collection<KeyPair> loadKeyPairs(String resourceKey, FilePasswordProvider passwordProvider, InputStream stream, Charset cs) throws IOException, GeneralSecurityException {
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(stream, "No stream instance"), Objects.requireNonNull(cs, "No charset"));){
            Collection<KeyPair> collection = this.loadKeyPairs(resourceKey, passwordProvider, reader);
            return collection;
        }
    }

    default public Collection<KeyPair> loadKeyPairs(String resourceKey, FilePasswordProvider passwordProvider, Reader r) throws IOException, GeneralSecurityException {
        try (BufferedReader br = new BufferedReader(Objects.requireNonNull(r, "No reader instance"), 8192);){
            Collection<KeyPair> collection = this.loadKeyPairs(resourceKey, passwordProvider, br);
            return collection;
        }
    }

    default public Collection<KeyPair> loadKeyPairs(String resourceKey, FilePasswordProvider passwordProvider, BufferedReader r) throws IOException, GeneralSecurityException {
        return this.loadKeyPairs(resourceKey, passwordProvider, IoUtils.readAllLines(r));
    }

    public Collection<KeyPair> loadKeyPairs(String var1, FilePasswordProvider var2, List<String> var3) throws IOException, GeneralSecurityException;
}

