/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode.helper;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kohsuke.asm6.ClassReader;
import org.kohsuke.asm6.Type;

class TypeHierarchyReader {
    TypeHierarchyReader() {
    }

    public boolean isInterface(Type t) {
        return this.hierarchyOf(t).isInterface();
    }

    public Type getSuperClass(Type t) {
        return this.hierarchyOf(t).getSuperType();
    }

    public boolean isAssignableFrom(Type to, Type from) {
        return this.hierarchyOf(to).isAssignableFrom(this.hierarchyOf(from), this);
    }

    public String getCommonSuperClass(String type1, String type2) {
        Type d;
        Type c = Type.getObjectType((String)type1);
        if (this.isAssignableFrom(c, d = Type.getObjectType((String)type2))) {
            return type1;
        }
        if (this.isAssignableFrom(d, c)) {
            return type2;
        }
        if (this.isInterface(c) || this.isInterface(d)) {
            return "java/lang/Object";
        }
        while (!this.isAssignableFrom(c = this.getSuperClass(c), d)) {
        }
        return c.getInternalName();
    }

    public TypeHierarchy hierarchyOf(Type t) {
        try {
            switch (t.getSort()) {
                case 1: {
                    return TypeHierarchy.BOOLEAN_HIERARCHY;
                }
                case 3: {
                    return TypeHierarchy.BYTE_HIERARCHY;
                }
                case 2: {
                    return TypeHierarchy.CHAR_HIERARCHY;
                }
                case 4: {
                    return TypeHierarchy.SHORT_HIERARCHY;
                }
                case 5: {
                    return TypeHierarchy.INT_HIERARCHY;
                }
                case 7: {
                    return TypeHierarchy.LONG_HIERARCHY;
                }
                case 6: {
                    return TypeHierarchy.FLOAT_HIERARCHY;
                }
                case 8: {
                    return TypeHierarchy.DOUBLE_HIERARCHY;
                }
                case 0: {
                    return TypeHierarchy.VOID_HIERARCHY;
                }
                case 9: {
                    return TypeHierarchy.hierarchyForArrayOfType(t);
                }
                case 10: {
                    return this.obtainHierarchyOf(this.reader(t));
                }
            }
            throw new Error("Programmer error: received a type whose getSort() wasn't matched.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ClassReader reader(Type t) throws IOException {
        return new ClassReader(t.getInternalName());
    }

    protected TypeHierarchy obtainHierarchyOf(ClassReader reader) {
        return new TypeHierarchy(Type.getObjectType((String)reader.getClassName()), reader.getSuperName() == null ? null : Type.getObjectType((String)reader.getSuperName()), this.interfacesTypesFrom(reader.getInterfaces()), (reader.getAccess() & 0x200) != 0);
    }

    private List<Type> interfacesTypesFrom(String[] interfaces) {
        Type[] interfaceTypes = new Type[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceTypes[i] = Type.getObjectType((String)interfaces[i]);
        }
        return Arrays.asList(interfaceTypes);
    }

    public static class TypeHierarchy {
        private static final List<Type> IMPLEMENTS_NO_INTERFACES = Collections.emptyList();
        private static final List<Type> IMPLICIT_ARRAY_INTERFACES = Collections.unmodifiableList(Arrays.asList(Type.getType(Cloneable.class), Type.getType(Serializable.class)));
        public static final TypeHierarchy JAVA_LANG_OBJECT = new TypeHierarchy(Type.getType(Object.class), null, IMPLEMENTS_NO_INTERFACES, false);
        public static final TypeHierarchy BOOLEAN_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.BOOLEAN_TYPE);
        public static final TypeHierarchy BYTE_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.BYTE_TYPE);
        public static final TypeHierarchy CHAR_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.CHAR_TYPE);
        public static final TypeHierarchy SHORT_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.SHORT_TYPE);
        public static final TypeHierarchy INT_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.INT_TYPE);
        public static final TypeHierarchy LONG_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.LONG_TYPE);
        public static final TypeHierarchy FLOAT_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.FLOAT_TYPE);
        public static final TypeHierarchy DOUBLE_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.DOUBLE_TYPE);
        public static final TypeHierarchy VOID_HIERARCHY = TypeHierarchy.typeHierarchyForPrimitiveType(Type.VOID_TYPE);
        private final Type thisType;
        private final Type superType;
        private final List<Type> interfaces;
        private final boolean isInterface;

        static TypeHierarchy hierarchyForArrayOfType(Type t) {
            return new TypeHierarchy(t, JAVA_LANG_OBJECT.type(), IMPLICIT_ARRAY_INTERFACES, false);
        }

        private static TypeHierarchy typeHierarchyForPrimitiveType(Type primitiveType) {
            return new TypeHierarchy(primitiveType, null, IMPLEMENTS_NO_INTERFACES, false);
        }

        public TypeHierarchy(Type thisType, Type superType, List<Type> interfaces, boolean isInterface) {
            this.thisType = thisType;
            this.superType = superType;
            this.interfaces = interfaces;
            this.isInterface = isInterface;
        }

        public Type type() {
            return this.thisType;
        }

        public boolean representsType(Type t) {
            return t.equals((Object)this.thisType);
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public Type getSuperType() {
            return this.superType;
        }

        public boolean isAssignableFrom(TypeHierarchy u, TypeHierarchyReader typeHierarchyReader) {
            if (this.assigningToObject()) {
                return true;
            }
            if (this.isSameType(u)) {
                return true;
            }
            if (this.isSuperTypeOf(u)) {
                return true;
            }
            if (this.isInterfaceImplementedBy(u)) {
                return true;
            }
            if (this.bothAreArrayTypes(u) && this.haveSameDimensionality(u)) {
                return JAVA_LANG_OBJECT.representsType(this.typeOfArray()) || this.arrayTypeIsAssignableFrom(u, typeHierarchyReader);
            }
            if (this.bothAreArrayTypes(u) && this.isObjectArrayWithSmallerDimensionalityThan(u)) {
                return true;
            }
            if (u.extendsObject() && !u.implementsAnyInterfaces()) {
                return false;
            }
            if (u.hasSuperType() && this.isAssignableFrom(u.getSuperType(), typeHierarchyReader)) {
                return true;
            }
            return u.implementsAnyInterfaces() && this.isAssignableFromAnyInterfaceImplementedBy(u, typeHierarchyReader);
        }

        public boolean isAssignableFrom(Type type, TypeHierarchyReader reader) {
            return this.isAssignableFrom(reader.hierarchyOf(type), reader);
        }

        private boolean isAssignableFromAnyInterfaceImplementedBy(TypeHierarchy u, TypeHierarchyReader typeHierarchyReader) {
            for (Type ui : u.interfaces) {
                if (!this.isAssignableFrom(ui, typeHierarchyReader)) continue;
                return true;
            }
            return false;
        }

        private boolean haveSameDimensionality(TypeHierarchy u) {
            return this.arrayDimensionality() == u.arrayDimensionality();
        }

        private boolean isObjectArrayWithSmallerDimensionalityThan(TypeHierarchy u) {
            return JAVA_LANG_OBJECT.representsType(this.typeOfArray()) && this.arrayDimensionality() <= u.arrayDimensionality();
        }

        private boolean arrayTypeIsAssignableFrom(TypeHierarchy u, TypeHierarchyReader reader) {
            TypeHierarchy thisArrayType = reader.hierarchyOf(this.typeOfArray());
            return thisArrayType.isAssignableFrom(reader.hierarchyOf(u.typeOfArray()), reader);
        }

        private boolean bothAreArrayTypes(TypeHierarchy u) {
            return this.isArrayType() && u.isArrayType();
        }

        private Type typeOfArray() {
            return Type.getType((String)this.thisType.getInternalName().substring(this.thisType.getDimensions()));
        }

        private int arrayDimensionality() {
            return this.thisType.getDimensions();
        }

        private boolean isArrayType() {
            return this.thisType.getSort() == 9;
        }

        private boolean isInterfaceImplementedBy(TypeHierarchy u) {
            return u.interfaces.contains(this.type());
        }

        private boolean isSuperTypeOf(TypeHierarchy u) {
            return this.type().equals((Object)u.getSuperType());
        }

        private boolean hasSuperType() {
            return this.getSuperType() != null && !JAVA_LANG_OBJECT.representsType(this.getSuperType());
        }

        private boolean implementsAnyInterfaces() {
            return !this.interfaces.isEmpty();
        }

        private boolean extendsObject() {
            return this.getSuperType() != null && JAVA_LANG_OBJECT.representsType(this.getSuperType());
        }

        private boolean isSameType(TypeHierarchy u) {
            return u.type().equals((Object)this.type());
        }

        private boolean assigningToObject() {
            return JAVA_LANG_OBJECT.representsType(this.type());
        }

        public int hashCode() {
            int prime = 31;
            return 31 * this.thisType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeHierarchy other = (TypeHierarchy)obj;
            return this.thisType.equals((Object)other.thisType);
        }

        public String toString() {
            return String.format("%s [type=%s]", this.getClass().getSimpleName(), this.thisType.toString());
        }
    }
}

