/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode.helper;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.bytecode.helper.TypeHierarchyReader;
import org.kohsuke.asm6.ClassReader;
import org.kohsuke.asm6.Type;

public class ClassLoadingReferenceTypeHierachyReader
extends TypeHierarchyReader {
    private ClassLoader classLoader;

    public ClassLoadingReferenceTypeHierachyReader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    protected ClassReader reader(Type t) throws IOException {
        URL url = this.classLoader.getResource(t.getInternalName() + ".class");
        if (url == null) {
            throw new RuntimeException("java.lang.ClassNotFoundException: " + t.getClassName());
        }
        byte[] classDefinition = IOUtils.toByteArray((URL)url);
        return new ClassReader(classDefinition);
    }
}

