/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.bytecode.ClassRewritingContext;
import org.jenkinsci.bytecode.Kind;
import org.jenkinsci.bytecode.MemberAdapter;
import org.jenkinsci.bytecode.NameAndType;
import org.kohsuke.asm6.Label;
import org.kohsuke.asm6.MethodVisitor;
import org.kohsuke.asm6.Type;

final class MemberTransformSpec
extends HashMap<NameAndType, Set<MemberAdapter>> {
    final Kind kind;

    MemberTransformSpec(Kind kind) {
        this.kind = kind;
    }

    MemberTransformSpec(MemberTransformSpec rhs) {
        this.kind = rhs.kind;
        for (Map.Entry e : rhs.entrySet()) {
            this.put(e.getKey(), new HashSet((Collection)e.getValue()));
        }
    }

    void addRewriteSpec(String name, Class type, MemberAdapter c) {
        NameAndType key = new NameAndType(Type.getDescriptor((Class)type), name);
        HashSet<MemberAdapter> specs = (HashSet<MemberAdapter>)this.get(key);
        if (specs == null) {
            specs = new HashSet<MemberAdapter>();
            this.put(key, specs);
        }
        for (MemberAdapter existing : specs) {
            if (!existing.owner.equals((Object)c.owner)) continue;
            specs.remove(existing);
            specs.add(c.compose(existing));
            return;
        }
        specs.add(c);
    }

    public boolean rewrite(ClassRewritingContext context, int opcode, String owner, String name, String desc, boolean intf, MethodVisitor base) {
        Set adapters = (Set)this.get(new NameAndType(desc, name));
        boolean modified = false;
        if (adapters != null) {
            Label end = new Label();
            Label next = new Label();
            for (MemberAdapter fr : adapters) {
                base.visitLabel(next);
                next = new Label();
                context.callTypeCheckMethod(fr.owner, Type.getObjectType((String)owner), base);
                base.visitJumpInsn(153, next);
                if (fr.adapt(context, opcode, owner, name, desc, intf, base)) {
                    modified = true;
                } else {
                    this.kind.visit(base, opcode, owner, name, desc, intf);
                }
                base.visitJumpInsn(167, end);
            }
            base.visitLabel(next);
            this.kind.visit(base, opcode, owner, name, desc, intf);
            base.visitLabel(end);
        } else {
            this.kind.visit(base, opcode, owner, name, desc, intf);
        }
        return modified;
    }

    private void println(MethodVisitor base, String msg) {
        base.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        base.visitLdcInsn((Object)msg);
        base.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
    }
}

