/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.bytecode.ClassRewritingContext;
import org.jenkinsci.bytecode.ClassWriter;
import org.jenkinsci.bytecode.TransformationSpec;
import org.kohsuke.asm5.ClassReader;
import org.kohsuke.asm5.ClassVisitor;
import org.kohsuke.asm5.MethodVisitor;
import org.kohsuke.asm5.commons.JSRInlinerAdapter;

public class Transformer {
    private static Logger LOGGER = Logger.getLogger(Transformer.class.getName());
    private volatile TransformationSpec spec = new TransformationSpec();

    public void loadRules(ClassLoader cl) throws IOException {
        this.loadRules(Collections.singleton(cl));
    }

    public synchronized void loadRules(Collection<? extends ClassLoader> loaders) throws IOException {
        TransformationSpec spec = new TransformationSpec(this.spec);
        for (ClassLoader classLoader : loaders) {
            spec.loadRule(classLoader);
        }
        this.spec = spec;
    }

    @Deprecated
    public byte[] transform(String className, byte[] image) {
        return this.transform(className, image, this.getClass().getClassLoader());
    }

    public byte[] transform(final String className, byte[] image, ClassLoader classLoader) {
        LOGGER.log(Level.FINEST, "transform({0}, {1})", new Object[]{className, classLoader});
        if (!this.spec.mayNeedTransformation(image)) {
            return image;
        }
        boolean regenerateStackMapTable = this.getBytecodeVersion(image) >= 50;
        ClassReader cr = new ClassReader(image);
        final ClassWriter cw = new ClassWriter(classLoader, regenerateStackMapTable ? 3 : 1);
        final boolean[] modified = new boolean[1];
        ClassVisitor jsrInliner = new ClassVisitor(327680, (ClassVisitor)cw){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor base = super.visitMethod(access, name, desc, signature, exceptions);
                LOGGER.log(Level.FINEST, "jsrInliner.visitMethod({0}, {1}, {2}, {3}, {4})", new Object[]{access, name, desc, signature, exceptions});
                return new JSRInlinerAdapter(327680, base, access, name, desc, signature, exceptions){

                    public void visitEnd() {
                        LOGGER.log(Level.FINEST, "visit end for {0}", this.name);
                        super.visitEnd();
                    }
                };
            }
        };
        cr.accept(new ClassVisitor(327680, (ClassVisitor)(regenerateStackMapTable ? jsrInliner : cw)){
            private ClassRewritingContext context;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(Math.max(version, 49), access, name, signature, superName, interfaces);
                this.context = new ClassRewritingContext(name);
            }

            public MethodVisitor visitMethod(int access, final String methodName, String methodDescriptor, final String methodSignature, String[] exceptions) {
                final MethodVisitor base = super.visitMethod(access, methodName, methodDescriptor, methodSignature, exceptions);
                return new MethodVisitor(327680, base){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        boolean _modified = ((Transformer)Transformer.this).spec.methods.rewrite(context, opcode, owner, name, desc, itf, base);
                        modified[0] = modified[0] | _modified;
                        LOGGER.log(Level.FINEST, "{0}.{1}({2}) {3} modified", new Object[]{className, methodName, methodSignature == null ? "" : methodSignature, _modified ? "was" : "was not"});
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        boolean _modified = ((Transformer)Transformer.this).spec.fields.rewrite(context, opcode, owner, name, desc, false, base);
                        modified[0] = modified[0] | _modified;
                        LOGGER.log(Level.FINEST, "{0}.{1}({2}) {3} modified", new Object[]{className, methodName, methodSignature == null ? "" : methodSignature, _modified ? "was" : "was not"});
                    }
                };
            }

            public void visitEnd() {
                LOGGER.log(Level.FINEST, "visitEnd(1) for {0}", className);
                this.context.generateCheckerMethods((ClassVisitor)cw);
                super.visitEnd();
                LOGGER.log(Level.FINEST, "visitEnd(2) for {0}", className);
            }
        }, 4);
        if (!modified[0]) {
            LOGGER.log(Level.FINER, "class {0} was not modified.", className);
            return image;
        }
        LOGGER.log(Level.FINER, "class {0} was modified.", className);
        return cw.toByteArray();
    }

    private int getBytecodeVersion(byte[] classData) {
        int version = (classData[6] & 0xFF) << 8 | classData[7] & 0xFF;
        LOGGER.log(Level.FINEST, "bytecode version is {0}", version);
        return version;
    }
}

