/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorators;
import org.jdbi.v3.sqlobject.Handlers;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlOperation;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

public class SqlObjectFactory
implements ExtensionFactory {
    private static final Object[] NO_ARGS = new Object[0];
    private final Map<Class<?>, Map<Method, Handler>> handlersCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<? extends Configurer>, Configurer> configurers = Collections.synchronizedMap(new WeakHashMap());

    SqlObjectFactory() {
    }

    public boolean accepts(Class<?> extensionType) {
        if (this.looksLikeSqlObject(extensionType)) {
            if (!extensionType.isInterface()) {
                throw new IllegalArgumentException("SQL Objects are only supported for interfaces.");
            }
            return true;
        }
        return false;
    }

    private boolean looksLikeSqlObject(Class<?> extensionType) {
        if (SqlObject.class.isAssignableFrom(extensionType)) {
            return true;
        }
        return Stream.of(extensionType.getMethods()).flatMap(m -> Stream.of(m.getAnnotations())).anyMatch(a -> a.annotationType().isAnnotationPresent(SqlOperation.class));
    }

    public <E> E attach(Class<E> extensionType, HandleSupplier handle) {
        Map<Method, Handler> handlers = this.methodHandlersFor(extensionType, (Handlers)handle.getConfig(Handlers.class), (HandlerDecorators)handle.getConfig(HandlerDecorators.class));
        ConfigRegistry instanceConfig = handle.getConfig().createCopy();
        for (Class<?> iface : extensionType.getInterfaces()) {
            this.forEachConfigurer(iface, (configurer, annotation) -> configurer.configureForType(instanceConfig, (Annotation)annotation, extensionType));
        }
        this.forEachConfigurer(extensionType, (configurer, annotation) -> configurer.configureForType(instanceConfig, (Annotation)annotation, extensionType));
        InvocationHandler invocationHandler = this.createInvocationHandler(extensionType, instanceConfig, handlers, handle);
        return extensionType.cast(Proxy.newProxyInstance(extensionType.getClassLoader(), new Class[]{extensionType}, invocationHandler));
    }

    private Map<Method, Handler> methodHandlersFor(Class<?> sqlObjectType, Handlers registry, HandlerDecorators decorators) {
        return this.handlersCache.computeIfAbsent(sqlObjectType, type -> {
            HashMap<Method, Handler> handlers = new HashMap<Method, Handler>();
            handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> sqlObjectType.getName() + '@' + Integer.toHexString(t.hashCode()), Object.class, "toString", new Class[0]));
            handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> t == a[0], Object.class, "equals", Object.class));
            handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> System.identityHashCode(t), Object.class, "hashCode", new Class[0]));
            handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> h.getHandle(), SqlObject.class, "getHandle", new Class[0]));
            try {
                handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> null, sqlObjectType, "finalize", new Class[0]));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            for (Method method : sqlObjectType.getMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                handlers.computeIfAbsent(method, m -> this.buildMethodHandler(sqlObjectType, (Method)m, registry, decorators));
            }
            handlers.keySet().stream().filter(m -> !m.isSynthetic()).collect(Collectors.groupingBy(m -> Arrays.asList(m.getName(), Arrays.asList(m.getParameterTypes())))).values().stream().filter(l -> l.size() > 1).findAny().ifPresent(ms -> {
                throw new UnableToCreateSqlObjectException(sqlObjectType + " has ambiguous methods " + ms + ", please resolve with an explicit override");
            });
            return handlers;
        });
    }

    private Handler buildMethodHandler(Class<?> sqlObjectType, Method method, Handlers handlers, HandlerDecorators decorators) {
        Handler handler = handlers.findFor(sqlObjectType, method).orElseThrow(() -> new IllegalStateException(String.format("Method %s.%s must be default or be annotated with a SQL method annotation.", sqlObjectType.getSimpleName(), method.getName())));
        return decorators.applyDecorators(handler, sqlObjectType, method);
    }

    private static Map<Method, Handler> handlerEntry(Handler handler, Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return Collections.singletonMap(klass.getMethod(methodName, parameterTypes), handler);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(String.format("can't find %s#%s%s", klass.getName(), methodName, Arrays.asList(parameterTypes)), e);
        }
    }

    private InvocationHandler createInvocationHandler(Class<?> sqlObjectType, ConfigRegistry instanceConfig, Map<Method, Handler> handlers, HandleSupplier handle) {
        ConcurrentHashMap methodConfigs = new ConcurrentHashMap();
        Function<Method, ConfigRegistry> createConfigForMethod = method -> {
            ConfigRegistry config = instanceConfig.createCopy();
            this.forEachConfigurer((AnnotatedElement)method, (configurer, annotation) -> configurer.configureForMethod(config, (Annotation)annotation, sqlObjectType, (Method)method));
            return config;
        };
        return (proxy, method, args) -> {
            ConfigRegistry methodConfig = ((ConfigRegistry)methodConfigs.computeIfAbsent(method, createConfigForMethod)).createCopy();
            Handler handler = (Handler)handlers.get(method);
            return handle.invokeInContext(new ExtensionMethod(sqlObjectType, method), methodConfig, () -> handler.invoke(proxy, args == null ? NO_ARGS : args, handle));
        };
    }

    private void forEachConfigurer(AnnotatedElement element, BiConsumer<Configurer, Annotation> consumer) {
        Stream.of(element.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(ConfiguringAnnotation.class)).forEach(a -> {
            ConfiguringAnnotation meta = a.annotationType().getAnnotation(ConfiguringAnnotation.class);
            consumer.accept(this.getConfigurer(meta.value()), (Annotation)a);
        });
    }

    private Configurer getConfigurer(Class<? extends Configurer> factoryClass) {
        return this.configurers.computeIfAbsent(factoryClass, c -> {
            try {
                return (Configurer)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Unable to instantiate configurer factory class " + factoryClass, e);
            }
        });
    }
}

