/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionMetadata;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.internal.OnDemandExtensions;
import org.jdbi.v3.sqlobject.AbstractSqlObjectFactory;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;

public final class GeneratorSqlObjectFactory
extends AbstractSqlObjectFactory
implements OnDemandExtensions.Factory {
    GeneratorSqlObjectFactory() {
    }

    public boolean accepts(Class<?> extensionType) {
        return GeneratorSqlObjectFactory.isConcrete(extensionType);
    }

    public Set<ExtensionFactory.FactoryFlag> getFactoryFlags() {
        return EnumSet.of(ExtensionFactory.FactoryFlag.DONT_USE_PROXY);
    }

    public <E> E attach(Class<E> extensionType, HandleSupplier handleSupplier) {
        if (!GeneratorSqlObjectFactory.isConcrete(extensionType)) {
            throw new IllegalStateException(String.format("Can not process %s, not generated SQL object", extensionType.getSimpleName()));
        }
        ConfigRegistry config = handleSupplier.getConfig();
        ExtensionMetadata extensionMetaData = ((Extensions)config.get(Extensions.class)).findMetadata(extensionType, (ExtensionFactory)this);
        ConfigRegistry instanceConfig = extensionMetaData.createInstanceConfiguration(config);
        try {
            Class<?> klazz = Class.forName(this.getGeneratedClassName(extensionType));
            return extensionType.cast(klazz.getConstructor(ExtensionMetadata.class, HandleSupplier.class, ConfigRegistry.class).newInstance(extensionMetaData, handleSupplier, instanceConfig));
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new UnableToCreateSqlObjectException(e);
        }
    }

    public Optional<Object> onDemand(Jdbi jdbi, Class<?> extensionType, Class<?> ... extraTypes) {
        if (!GeneratorSqlObjectFactory.isConcrete(extensionType)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Class.forName(this.getOnDemandClassName(extensionType)).getConstructor(Jdbi.class).newInstance(jdbi));
        }
        catch (ExceptionInInitializerError | ReflectiveOperationException | SecurityException e) {
            throw new UnableToCreateSqlObjectException(e);
        }
    }

    private String getGeneratedClassName(Class<?> extensionType) {
        return extensionType.getPackage().getName() + "." + extensionType.getSimpleName() + "Impl";
    }

    private String getOnDemandClassName(Class<?> extensionType) {
        return this.getGeneratedClassName(extensionType) + "$OnDemand";
    }
}

