/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.sqlobject.Handler;

class DefaultMethodHandler
implements Handler {
    private static final Method PRIVATE_LOOKUP_IN = DefaultMethodHandler.privateLookupIn();
    private static final Map<Class<?>, MethodHandles.Lookup> PRIVATE_LOOKUPS = Collections.synchronizedMap(new WeakHashMap());
    private final MethodHandle methodHandle;

    private static Method privateLookupIn() {
        try {
            return MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    private static MethodHandles.Lookup lookupFor(Class<?> clazz) {
        if (PRIVATE_LOOKUP_IN != null) {
            try {
                return (MethodHandles.Lookup)PRIVATE_LOOKUP_IN.invoke(null, clazz, MethodHandles.lookup());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                String message = String.format("Error invoking MethodHandles.privateLookupIn(%s.class, MethodHandles.lookup()) in JDK 9+ runtime", clazz);
                throw new RuntimeException(message, e);
            }
        }
        return PRIVATE_LOOKUPS.computeIfAbsent(clazz, type -> {
            try {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return (MethodHandles.Lookup)constructor.newInstance(type, 15);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    DefaultMethodHandler(Method method) {
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            this.methodHandle = DefaultMethodHandler.lookupFor(declaringClass).unreflectSpecial(method, declaringClass);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object invoke(Object target, Object[] args, HandleSupplier handle) {
        try {
            return this.methodHandle.bindTo(target).invokeWithArguments(args);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

