/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement.internal;

import java.lang.reflect.Method;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.statement.UseRowReducer;
import org.jdbi.v3.sqlobject.statement.internal.CustomizingStatementHandler;
import org.jdbi.v3.sqlobject.statement.internal.ResultReturner;
import org.jdbi.v3.sqlobject.statement.internal.SqlObjectStatementConfiguration;

public class SqlQueryHandler
extends CustomizingStatementHandler<Query> {
    private final ResultReturner magic;

    public SqlQueryHandler(Class<?> sqlObjectType, Method method) {
        super(sqlObjectType, method);
        this.magic = ResultReturner.forMethod(sqlObjectType, method);
    }

    @Override
    void configureReturner(Query q, SqlObjectStatementConfiguration cfg) {
        UseRowMapper useRowMapper = this.getMethod().getAnnotation(UseRowMapper.class);
        UseRowReducer useRowReducer = this.getMethod().getAnnotation(UseRowReducer.class);
        if (useRowReducer != null && useRowMapper != null) {
            throw new IllegalStateException("Cannot declare @UseRowMapper and @UseRowReducer on the same method.");
        }
        cfg.setReturner(() -> {
            StatementContext ctx = q.getContext();
            QualifiedType<?> elementType = this.magic.elementType(ctx);
            if (useRowReducer != null) {
                return this.magic.reducedResult(q.reduceRows(SqlQueryHandler.rowReducerFor(useRowReducer)), ctx);
            }
            ResultIterable iterable = useRowMapper == null ? q.mapTo(elementType) : q.map(SqlQueryHandler.rowMapperFor(useRowMapper));
            return this.magic.mappedResult(iterable, ctx);
        });
    }

    @Override
    Query createStatement(Handle handle, String locatedSql) {
        return handle.createQuery(locatedSql);
    }
}

