/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.transaction.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementCustomizer;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.transaction.TransactionIsolation;

public class TransactionIsolationFactory
implements SqlStatementCustomizerFactory {
    @Override
    public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
        TransactionIsolationLevel level = ((TransactionIsolation)annotation).value();
        return stmt -> this.setTxnIsolation(stmt, level);
    }

    @Override
    public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
        return this.createForType(annotation, sqlObjectType);
    }

    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
        return (stmt, level) -> this.setTxnIsolation(stmt, (TransactionIsolationLevel)level);
    }

    private void setTxnIsolation(SqlStatement<?> stmt, final TransactionIsolationLevel level) throws SQLException {
        final int initialLevel = stmt.getContext().getConnection().getTransactionIsolation();
        stmt.addCustomizer(new StatementCustomizer(){

            public void beforeExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
                this.setTxnIsolation(ctx, level.intValue());
            }

            public void afterExecution(PreparedStatement stmt, StatementContext ctx) throws SQLException {
                this.setTxnIsolation(ctx, initialLevel);
            }

            private void setTxnIsolation(StatementContext ctx, int level2) throws SQLException {
                Connection c = ctx.getConnection();
                if (c.getTransactionIsolation() != level2) {
                    c.setTransactionIsolation(level2);
                }
            }
        });
    }
}

