/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;

@ConfiguringAnnotation(value=Impl.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterConstructorMapper {
    public Class<?>[] value();

    public String[] prefix() default {};

    public static class Impl
    implements Configurer {
        @Override
        public void configureForMethod(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType, Method method) {
            this.configureForType(registry, annotation, sqlObjectType);
        }

        @Override
        public void configureForType(ConfigRegistry registry, Annotation annotation, Class<?> sqlObjectType) {
            RegisterConstructorMapper registerConstructorMapper = (RegisterConstructorMapper)annotation;
            RowMappers mappers = (RowMappers)registry.get(RowMappers.class);
            Class<?>[] types = registerConstructorMapper.value();
            String[] prefixes = registerConstructorMapper.prefix();
            if (prefixes.length == 0) {
                for (Class<?> type : types) {
                    mappers.register(ConstructorMapper.factory(type));
                }
            } else if (prefixes.length == types.length) {
                for (int i = 0; i < types.length; ++i) {
                    mappers.register(ConstructorMapper.factory(types[i], (String)prefixes[i]));
                }
            } else {
                throw new IllegalStateException("RegisterConstructorMapper.prefix() must have the same number of elements as value()");
            }
        }
    }
}

