/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.extension.Extensions;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.SqlObjectFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlMethodAnnotation(value=Impl.class)
public @interface CreateSqlObject {

    public static class Impl
    implements Handler {
        private final Method method;

        public Impl(Method method) {
            this.method = method;
        }

        @Override
        public Object invoke(Object target, Object[] args, HandleSupplier handle) throws Exception {
            return ((SqlObjectFactory)((Extensions)handle.getConfig(Extensions.class)).findFactory(SqlObjectFactory.class).orElseThrow(() -> new IllegalStateException("Can't locate SqlObject factory"))).attach(this.method.getReturnType(), handle);
        }
    }
}

