/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface MaxRows {
    public int value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            int va = ((MaxRows)annotation).value();
            return q -> {
                assert (q instanceof Query);
                ((Query)q).setMaxRows(va);
            };
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            int va = ((MaxRows)annotation).value();
            return q -> {
                assert (q instanceof Query);
                ((Query)q).setMaxRows(va);
            };
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Object arg) {
            Integer va = (Integer)arg;
            return q -> {
                assert (q instanceof Query);
                ((Query)q).setMaxRows(va.intValue());
            };
        }
    }
}

