/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface BindMap {
    public String value() default "";

    public String[] keys() default {};

    public boolean convertKeys() default false;

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation a, Class<?> sqlObjectType, Method method, Parameter param, int index, Object arg) {
            BindMap annotation = (BindMap)a;
            List<String> keys = Arrays.asList(annotation.keys());
            String prefix = annotation.value().isEmpty() ? "" : annotation.value() + ".";
            Map map = (Map)arg;
            HashMap toBind = new HashMap();
            map.forEach((k, v) -> {
                if (annotation.convertKeys() || k instanceof String) {
                    String key = k.toString();
                    if (keys.isEmpty() || keys.contains(key)) {
                        toBind.put(prefix + key, v);
                    }
                } else {
                    throw new IllegalArgumentException("Key " + k + " (of " + k.getClass() + ") must be a String");
                }
            });
            keys.forEach(key -> toBind.putIfAbsent(prefix + key, null));
            return stmt -> stmt.bindMap(toBind);
        }
    }
}

