/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface DefineIn {
    public String value() default "";

    public static final class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, Object arg) {
            List<Object> argsList;
            if (arg instanceof List) {
                argsList = (List<Object>)arg;
            } else if (arg instanceof Object[]) {
                argsList = Arrays.asList((Object[])arg);
            } else {
                if (arg == null) {
                    throw new IllegalArgumentException("A null object was passed as a @DefineIn parameter. @DefineIn is only supported on List and array arguments");
                }
                throw new IllegalArgumentException("A " + arg.getClass() + " object was passed as a @DefineIn parameter. @DefineIn is only supported on List and array arguments");
            }
            if (argsList.isEmpty()) {
                throw new IllegalArgumentException("An empty list was passed as a @DefineIn parameter. Can't define an empty attribute.");
            }
            DefineIn d = (DefineIn)annotation;
            String name = ParameterUtil.getParameterName(d, d.value(), param);
            StringBuilder sb = new StringBuilder();
            boolean firstItem = true;
            for (Object o : argsList) {
                if (o == null) {
                    throw new IllegalArgumentException("A @DefineIn parameter was passed a list with null values in it.");
                }
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(',');
                }
                sb.append(o.toString());
            }
            return q -> q.define(name, (Object)sb.toString());
        }
    }
}

