/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.Query;
import org.jdbi.v3.mapper.RowMapper;
import org.jdbi.v3.sqlobject.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.SqlStatementCustomizingAnnotation;

@SqlStatementCustomizingAnnotation(value=Factory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface RegisterRowMapper {
    public Class<? extends RowMapper<?>>[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.create((RegisterRowMapper)annotation);
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            return this.create((RegisterRowMapper)annotation);
        }

        private SqlStatementCustomizer create(RegisterRowMapper ma) {
            RowMapper[] m = new RowMapper[ma.value().length];
            try {
                Class<? extends RowMapper<?>>[] mcs = ma.value();
                for (int i = 0; i < mcs.length; ++i) {
                    m[i] = mcs[i].newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to create a specified row mapper", e);
            }
            return statement -> {
                if (statement instanceof Query) {
                    Query q = (Query)statement;
                    for (RowMapper mapper : m) {
                        q.registerRowMapper(mapper);
                    }
                }
            };
        }
    }
}

