/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import com.pgvector.PGbit;
import com.pgvector.PGvector;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.postgres.BlobInputStreamArgumentFactory;
import org.jdbi.v3.postgres.BlobInputStreamColumnMapperFactory;
import org.jdbi.v3.postgres.ClobReaderArgumentFactory;
import org.jdbi.v3.postgres.ClobReaderColumnMapperFactory;
import org.jdbi.v3.postgres.DurationArgumentFactory;
import org.jdbi.v3.postgres.DurationColumnMapperFactory;
import org.jdbi.v3.postgres.HStoreArgumentFactory;
import org.jdbi.v3.postgres.HStoreColumnMapper;
import org.jdbi.v3.postgres.InetArgumentFactory;
import org.jdbi.v3.postgres.JavaTimeArgumentFactory;
import org.jdbi.v3.postgres.JavaTimeMapperFactory;
import org.jdbi.v3.postgres.JsonArgumentFactory;
import org.jdbi.v3.postgres.MacAddrArgumentFactory;
import org.jdbi.v3.postgres.MacAddrColumnMapper;
import org.jdbi.v3.postgres.PGobjectArgumentFactory;
import org.jdbi.v3.postgres.PGobjectColumnMapperFactory;
import org.jdbi.v3.postgres.PeriodArgumentFactory;
import org.jdbi.v3.postgres.PeriodColumnMapperFactory;
import org.jdbi.v3.postgres.PgLobApiImpl;
import org.jdbi.v3.postgres.PostgresTypes;
import org.jdbi.v3.postgres.TypedEnumArgumentFactory;
import org.jdbi.v3.postgres.UUIDArgumentFactory;
import org.jdbi.v3.postgres.internal.BitStringEnumSetArgumentFactory;
import org.jdbi.v3.postgres.internal.BitStringEnumSetMapperFactory;
import org.jdbi.v3.postgres.internal.ByteaArrayType;
import org.postgresql.PGConnection;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGmoney;

public class PostgresPlugin
extends JdbiPlugin.Singleton {
    private static final boolean PGVECTOR_AVAILABLE = JdbiClassUtils.isPresent((String)"com.pgvector.PGvector");
    private final boolean installLegacy;

    public static PostgresPlugin noUnqualifiedHstoreBindings() {
        return new PostgresPlugin(false);
    }

    public PostgresPlugin() {
        this(true);
    }

    protected PostgresPlugin(boolean installLegacy) {
        this.installLegacy = installLegacy;
    }

    public void customizeJdbi(Jdbi jdbi) {
        jdbi.registerArgument((ArgumentFactory)new TypedEnumArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new JavaTimeArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new DurationArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new PeriodArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new InetArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new HStoreArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new MacAddrArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new UUIDArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new PGobjectArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new BitStringEnumSetArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new BlobInputStreamArgumentFactory());
        jdbi.registerArgument((ArgumentFactory)new ClobReaderArgumentFactory());
        jdbi.registerArrayType(PGbox.class, "box");
        jdbi.registerArrayType(PGcircle.class, "circle");
        jdbi.registerArrayType(PGInterval.class, "interval");
        jdbi.registerArrayType(PGline.class, "line");
        jdbi.registerArrayType(PGlseg.class, "lseg");
        jdbi.registerArrayType(PGmoney.class, "money");
        jdbi.registerArrayType(PGpath.class, "path");
        jdbi.registerArrayType(PGpoint.class, "point");
        jdbi.registerArrayType(PGpolygon.class, "polygon");
        jdbi.registerArrayType((SqlArrayType)new ByteaArrayType());
        jdbi.registerColumnMapper((ColumnMapperFactory)new JavaTimeMapperFactory());
        jdbi.registerColumnMapper((ColumnMapper)new HStoreColumnMapper());
        jdbi.registerColumnMapper((ColumnMapper)new MacAddrColumnMapper());
        jdbi.registerColumnMapper((ColumnMapperFactory)new DurationColumnMapperFactory());
        jdbi.registerColumnMapper((ColumnMapperFactory)new PeriodColumnMapperFactory());
        jdbi.registerColumnMapper((ColumnMapperFactory)new PGobjectColumnMapperFactory());
        jdbi.registerColumnMapper((ColumnMapperFactory)new BitStringEnumSetMapperFactory());
        jdbi.registerColumnMapper((ColumnMapperFactory)new BlobInputStreamColumnMapperFactory());
        jdbi.registerColumnMapper((ColumnMapperFactory)new ClobReaderColumnMapperFactory());
        if (this.installLegacy) {
            jdbi.registerArgument((arg_0, arg_1, arg_2) -> ((HStoreArgumentFactory)new HStoreArgumentFactory()).build(arg_0, arg_1, arg_2));
            jdbi.registerColumnMapper((GenericType)new GenericType<Map<String, String>>(){}, (ColumnMapper)new HStoreColumnMapper());
        }
        if (JdbiClassUtils.isPresent((String)"org.jdbi.v3.json.JsonConfig")) {
            jdbi.registerArgument((ArgumentFactory)new JsonArgumentFactory());
        }
    }

    public Handle customizeHandle(Handle handle) throws SQLException {
        Connection conn = handle.getConnection();
        if (PGVECTOR_AVAILABLE) {
            VectorEnabler.enable(conn);
        }
        PGConnection pgConnection = conn.unwrap(PGConnection.class);
        return (Handle)handle.configure(PostgresTypes.class, pt -> {
            pt.addTypesToConnection(pgConnection);
            pt.setLobApi(new PgLobApiImpl(conn));
        });
    }

    static final class VectorEnabler {
        private VectorEnabler() {
            throw new UtilityClassException();
        }

        static void enable(Connection conn) throws SQLException {
            PGvector.registerTypes((Connection)conn);
            PGbit.registerType((Connection)conn);
        }
    }
}

