/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.util.Map;
import org.jdbi.v3.core.array.SqlArrayTypes;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.CopyOnWriteHashMap;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.postgres.PgLobApi;
import org.postgresql.PGConnection;
import org.postgresql.util.PGobject;

public class PostgresTypes
implements JdbiConfig<PostgresTypes> {
    private final Map<Class<? extends PGobject>, String> types;
    private ConfigRegistry registry;
    private PgLobApi lob;

    public PostgresTypes() {
        this.types = new CopyOnWriteHashMap();
    }

    private PostgresTypes(PostgresTypes that) {
        this.types = new CopyOnWriteHashMap(that.types);
        this.lob = that.lob;
    }

    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    public PostgresTypes registerCustomType(Class<? extends PGobject> clazz, String typeName) {
        ((SqlArrayTypes)this.registry.get(SqlArrayTypes.class)).register(clazz, typeName);
        this.types.put(clazz, typeName);
        return this;
    }

    PostgresTypes setLobApi(PgLobApi newLob) {
        this.lob = newLob;
        return this;
    }

    public PgLobApi getLobApi() {
        return this.lob;
    }

    void addTypesToConnection(PGConnection connection) {
        this.types.forEach((clazz, type) -> Unchecked.biConsumer((arg_0, arg_1) -> ((PGConnection)connection).addDataType(arg_0, arg_1)).accept(type, clazz));
    }

    public PostgresTypes createCopy() {
        return new PostgresTypes(this);
    }
}

