/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.postgres;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jdbi.v3.core.StatementContext;
import org.jdbi.v3.core.argument.Argument;

public class ArrayArgument
implements Argument {
    private final String elementType;
    private final Object[] array;

    private ArrayArgument(String elementType, Object newArray) {
        this.elementType = elementType;
        int length = Array.getLength(newArray);
        this.array = new Object[length];
        for (int i = 0; i < length; ++i) {
            this.array[i] = Array.get(newArray, i);
        }
    }

    public static ArrayArgument fromArray(String elementType, Object[] array) {
        return ArrayArgument.fromAnyArray(elementType, array);
    }

    public static ArrayArgument fromAnyArray(String elementType, Object array) {
        return new ArrayArgument(elementType, array);
    }

    public static ArrayArgument fromVarargs(String elementType, Object ... elements) {
        return ArrayArgument.fromArray(elementType, elements);
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        java.sql.Array sqlArray = statement.getConnection().createArrayOf(this.elementType, this.array);
        statement.setArray(position, sqlArray);
    }
}

