/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.CompletableFuture;
import org.jdbi.v3.core.cache.JdbiCache;
import org.jdbi.v3.core.cache.JdbiCacheLoader;

class JdbiCaffeineCache<K, V>
implements JdbiCache<K, V> {
    private final Cache<K, CompletableFuture<V>> cache;
    private final JdbiCacheLoader<K, V> loader;

    JdbiCaffeineCache(Caffeine<Object, Object> caffeine, JdbiCacheLoader<K, V> loader) {
        this.loader = loader;
        this.cache = caffeine.build();
    }

    public V get(K key) {
        return this.doGet(key, this.loader);
    }

    public V getWithLoader(K key, JdbiCacheLoader<K, V> myLoader) {
        return this.doGet(key, myLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    private V doGet(K key, JdbiCacheLoader<K, V> loader) {
        CompletableFuture future = this.cache.asMap().computeIfAbsent(key, k -> new CompletableFuture());
        if (future.isDone()) {
            return (V)future.join();
        }
        CompletableFuture completableFuture = future;
        synchronized (completableFuture) {
            if (!future.isDone()) {
                future.complete(loader == null ? null : loader.create(key));
            }
            return (V)future.join();
        }
    }

    public CacheStats getStats() {
        return this.cache.stats();
    }
}

