/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.options;

import org.jclouds.http.options.BaseHttpRequestOptions;
import org.jclouds.openstack.glance.v1_0.domain.ContainerFormat;
import org.jclouds.openstack.glance.v1_0.domain.DiskFormat;
import org.jclouds.openstack.glance.v1_0.domain.StoreType;
import org.jclouds.openstack.glance.v1_0.options.ImageField;

public class UpdateImageOptions
extends BaseHttpRequestOptions {
    public UpdateImageOptions name(String name) {
        this.headers.put((Object)ImageField.NAME.asHeader(), (Object)name);
        return this;
    }

    public UpdateImageOptions storeType(StoreType storeType) {
        this.headers.put((Object)ImageField.STORE.asHeader(), (Object)storeType.toString());
        return this;
    }

    public UpdateImageOptions diskFormat(DiskFormat diskFormat) {
        this.headers.put((Object)ImageField.DISK_FORMAT.asHeader(), (Object)diskFormat.toString());
        return this;
    }

    public UpdateImageOptions containerFormat(ContainerFormat containerFormat) {
        this.headers.put((Object)ImageField.CONTAINER_FORMAT.asHeader(), (Object)containerFormat.toString());
        return this;
    }

    public UpdateImageOptions size(long size) {
        this.headers.put((Object)ImageField.SIZE.asHeader(), (Object)Long.toString(size));
        return this;
    }

    public UpdateImageOptions checksum(String checksum) {
        this.headers.put((Object)ImageField.CHECKSUM.asHeader(), (Object)checksum);
        return this;
    }

    public UpdateImageOptions location(String location) {
        this.headers.put((Object)ImageField.LOCATION.asHeader(), (Object)location);
        return this;
    }

    public UpdateImageOptions isPublic(boolean isPublic) {
        this.headers.put((Object)ImageField.IS_PUBLIC.asHeader(), (Object)Boolean.toString(isPublic));
        return this;
    }

    public UpdateImageOptions isProtected(boolean isProtected) {
        this.headers.put((Object)ImageField.PROTECTED.asHeader(), (Object)Boolean.toString(isProtected));
        return this;
    }

    public UpdateImageOptions minRam(long ram) {
        this.headers.put((Object)ImageField.MIN_RAM.asHeader(), (Object)Long.toString(ram));
        return this;
    }

    public UpdateImageOptions minDisk(long disk) {
        this.headers.put((Object)ImageField.MIN_DISK.asHeader(), (Object)Long.toString(disk));
        return this;
    }

    public UpdateImageOptions owner(String owner) {
        this.headers.put((Object)ImageField.OWNER.asHeader(), (Object)owner);
        return this;
    }

    public UpdateImageOptions property(String key, String value) {
        if (!key.toLowerCase().startsWith(ImageField.PROPERTY.asHeader() + "-")) {
            key = ImageField.PROPERTY.asHeader() + "-" + key;
        }
        this.headers.put((Object)key, (Object)value);
        return this;
    }

    public static class Builder {
        public static UpdateImageOptions name(String name) {
            return new UpdateImageOptions().name(name);
        }

        public static UpdateImageOptions storeType(StoreType storeType) {
            return new UpdateImageOptions().storeType(storeType);
        }

        public static UpdateImageOptions diskFormat(DiskFormat diskFormat) {
            return new UpdateImageOptions().diskFormat(diskFormat);
        }

        public static UpdateImageOptions containerFormat(ContainerFormat containerFormat) {
            return new UpdateImageOptions().containerFormat(containerFormat);
        }

        public static UpdateImageOptions size(long size) {
            return new UpdateImageOptions().size(size);
        }

        public static UpdateImageOptions checksum(String checksum) {
            return new UpdateImageOptions().checksum(checksum);
        }

        public static UpdateImageOptions location(String location) {
            return new UpdateImageOptions().location(location);
        }

        public static UpdateImageOptions isPublic(boolean isPublic) {
            return new UpdateImageOptions().isPublic(isPublic);
        }

        public static UpdateImageOptions isProtected(boolean isProtected) {
            return new UpdateImageOptions().isProtected(isProtected);
        }

        public static UpdateImageOptions minRam(long ram) {
            return new UpdateImageOptions().minRam(ram);
        }

        public static UpdateImageOptions minDisk(long disk) {
            return new UpdateImageOptions().minDisk(disk);
        }

        public static UpdateImageOptions owner(String owner) {
            return new UpdateImageOptions().owner(owner);
        }

        public static UpdateImageOptions property(String key, String value) {
            return new UpdateImageOptions().property(key, value);
        }
    }
}

