/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.glance.v1_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.glance.v1_0.GlanceApi;
import org.jclouds.openstack.glance.v1_0.domain.ImageDetails;
import org.jclouds.openstack.glance.v1_0.features.ImageApi;
import org.jclouds.openstack.glance.v1_0.options.ListImageOptions;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.domain.Link;

@Singleton
@Beta
public class ParseImageDetails
extends ParseJson<Images> {
    @Inject
    public ParseImageDetails(Json json) {
        super(json, TypeLiteral.get(Images.class));
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<ImageDetails, ToPagedIterable> {
        private final GlanceApi api;

        @Inject
        protected ToPagedIterable(GlanceApi api) {
            this.api = (GlanceApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<ImageDetails>> markerToNextForArg0(Optional<Object> arg0) {
            String zone = arg0.isPresent() ? arg0.get().toString() : null;
            final ImageApi imageApi = this.api.getImageApiForZone(zone);
            return new Function<Object, IterableWithMarker<ImageDetails>>(){

                public IterableWithMarker<ImageDetails> apply(Object input) {
                    return (IterableWithMarker)IterableWithMarker.class.cast(imageApi.listInDetail(ListImageOptions.Builder.marker(input.toString())));
                }

                public String toString() {
                    return "listInDetail()";
                }
            };
        }
    }

    static class Images
    extends PaginatedCollection<ImageDetails> {
        @ConstructorProperties(value={"images", "images_links"})
        protected Images(Iterable<ImageDetails> images, Iterable<Link> images_links) {
            super(images, images_links);
        }
    }
}

