/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.annotated.runtime.InvokableAnnotatedMethod;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Decorators;
import org.jboss.weld.util.reflection.Reflections;

class DecoratedMethods {
    private static final Object NULL_MARKER = new Object();
    private final Set<InvokableAnnotatedMethod<?>> decoratedTypeMethods;
    private final ConcurrentMap<Method, Object> cache;

    DecoratedMethods(BeanManagerImpl manager, WeldDecorator<?> decorator) {
        this.decoratedTypeMethods = Decorators.getDecoratorMethods(manager, decorator);
        this.cache = new ConcurrentHashMap<Method, Object>();
    }

    public InvokableAnnotatedMethod<?> getDecoratedMethod(Method method) {
        Object value;
        if (!this.cache.containsKey(method)) {
            this.cache.putIfAbsent(method, this.findMatchingDecoratedMethod(method));
        }
        if ((value = this.cache.get(method)) == NULL_MARKER) {
            return null;
        }
        return (InvokableAnnotatedMethod)Reflections.cast(value);
    }

    private Object findMatchingDecoratedMethod(Method method) {
        for (InvokableAnnotatedMethod<?> decoratedMethod : this.decoratedTypeMethods) {
            if (!decoratedMethod.getJavaMember().equals(method)) continue;
            return decoratedMethod;
        }
        for (InvokableAnnotatedMethod<?> decoratedMethod : this.decoratedTypeMethods) {
            if (!this.matches(decoratedMethod, method)) continue;
            return decoratedMethod;
        }
        return NULL_MARKER;
    }

    private boolean matches(InvokableAnnotatedMethod<?> decoratedMethod, Method candidate) {
        if (candidate.getParameterTypes().length != decoratedMethod.getParameters().size()) {
            return false;
        }
        if (!candidate.getName().equals(decoratedMethod.getJavaMember().getName())) {
            return false;
        }
        for (int i = 0; i < candidate.getParameterTypes().length; ++i) {
            if (decoratedMethod.getJavaMember().getParameterTypes()[i].isAssignableFrom(candidate.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }
}

