/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuiltProject;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.BuildStageImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.BuiltProjectImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.pom.equipped.ResolverErrorOutputHandler;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.pom.equipped.ResolverOutputHandler;

public class BuildTrigger {
    private final String SAX_PARSER_FACTORY_KEY = "javax.xml.parsers.SAXParserFactory";
    private final Logger log = Logger.getLogger(BuildStageImpl.class.getName());
    private final boolean ignoreFailure;
    private final File mavenInstallation;
    private final InvocationRequest invocationRequest;
    private final Invoker invoker;
    private final StringBuffer logBuffer;
    private final boolean quiet;

    public BuildTrigger(File mavenInstallation, InvocationRequest invocationRequest, Invoker invoker, StringBuffer logBuffer, boolean quiet, boolean ignoreFailure) {
        this.mavenInstallation = mavenInstallation;
        this.invocationRequest = invocationRequest;
        this.invoker = invoker;
        this.logBuffer = logBuffer;
        this.quiet = quiet;
        this.ignoreFailure = ignoreFailure;
    }

    private void setOutputHandlers(String expectedRegex, CountDownLatch countDownLatch) {
        if (this.logBuffer != null) {
            ResolverErrorOutputHandler errorOutputHandler = new ResolverErrorOutputHandler(this.logBuffer, expectedRegex, countDownLatch);
            ResolverOutputHandler outputHandler = new ResolverOutputHandler(this.logBuffer, expectedRegex, countDownLatch);
            this.invocationRequest.setOutputHandler((InvocationOutputHandler)outputHandler);
            this.invocationRequest.setErrorHandler((InvocationOutputHandler)errorOutputHandler);
            errorOutputHandler.setQuiet(this.quiet);
            outputHandler.setQuiet(this.quiet);
        }
    }

    public BuiltProject build(String expectedRegex, CountDownLatch countDownLatch) {
        InvocationResult result;
        String oldValue;
        block7: {
            oldValue = this.removeSAXParserFactoryProperty();
            if (this.mavenInstallation != null) {
                this.invocationRequest.setMavenHome(this.mavenInstallation);
            }
            this.setOutputHandlers(expectedRegex, countDownLatch);
            result = null;
            try {
                this.printStatus("started");
                result = this.invoker.execute(this.invocationRequest);
                if (result.getExitCode() == 0) break block7;
                if (this.ignoreFailure) {
                    this.log.severe("Maven build failed - the exit code is: " + result.getExitCode());
                    break block7;
                }
                throw new IllegalStateException("Maven build failed - the exit code is: " + result.getExitCode() + "\n To ignore this failure use method ignoreFailure()", (Throwable)result.getExecutionException());
            }
            catch (MavenInvocationException e) {
                throw new IllegalStateException("Execution of a Maven build has failed", e);
            }
            finally {
                this.printStatus("stopped");
            }
        }
        this.setSAXParserFactoryProperty(oldValue);
        return this.getBuiltProject(result);
    }

    private void printStatus(String status) {
        File pomFile = this.invocationRequest.getPomFile();
        String projectPom = "";
        if (pomFile == null) {
            String pomFileName;
            File baseDirectory = this.invocationRequest.getBaseDirectory();
            if (baseDirectory != null) {
                projectPom = baseDirectory.getName() + File.separator;
            }
            if ((pomFileName = this.invocationRequest.getPomFileName()) != null) {
                projectPom = projectPom + pomFileName;
            }
        } else {
            projectPom = pomFile.getParentFile().getName() + File.separator + pomFile.getName();
        }
        StringBuffer borders = new StringBuffer("==========================================");
        for (int i = 0; i < projectPom.length(); ++i) {
            borders.append("=");
        }
        System.out.println(borders);
        System.out.println("===   Embedded Maven build " + status + ": " + projectPom + "   ===");
        System.out.println(borders);
    }

    private BuiltProject getBuiltProject(InvocationResult result) {
        File pomFile = this.invocationRequest.getPomFile();
        if (pomFile == null) {
            pomFile = new File(this.invocationRequest.getBaseDirectory() + File.separator + "pom.xml");
        }
        BuiltProjectImpl builtProject = new BuiltProjectImpl(pomFile, this.invocationRequest.getGlobalSettingsFile(), this.invocationRequest.getUserSettingsFile(), this.invocationRequest.getProperties(), this.profilesInArray());
        if (this.logBuffer != null) {
            builtProject.setMavenLog(this.logBuffer.toString());
        }
        if (result != null) {
            builtProject.setMavenBuildExitCode(result.getExitCode());
        }
        return builtProject;
    }

    private String[] profilesInArray() {
        String[] profiles = new String[]{};
        List profilesList = this.invocationRequest.getProfiles();
        if (profilesList != null) {
            profiles = new String[profilesList.size()];
            profiles = profilesList.toArray(profiles);
        }
        return profiles;
    }

    private String removeSAXParserFactoryProperty() {
        Object value = System.getProperties().remove("javax.xml.parsers.SAXParserFactory");
        return value != null ? (String)value : null;
    }

    private void setSAXParserFactoryProperty(String oldValue) {
        if (oldValue != null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", oldValue);
        }
    }
}

