/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.bootstrap.test;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.ssl.SSLContextBuilder;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;

public class TestSslUtil {
    private static final AtomicBoolean SETUP = new AtomicBoolean(false);
    private static final String WORK_DIR = "./target/test-classes/";
    private static final Path SERVER_KEYSTORE_FILE = Path.of("./target/test-classes/", "server.keystore");
    private static final Path SERVER_TRUSTSTORE_FILE = Path.of("./target/test-classes/", "server.truststore");
    private static final Path CLIENT_KEYSTORE_FILE = Path.of("./target/test-classes/", "client.keystore");
    private static final Path CLIENT_TRUSTSTORE_FILE = Path.of("./target/test-classes/", "client.truststore");
    private static final String ALIAS = "self-signed";
    private static final String CLIENT_DNS_STRING = "CN=localhost, OU=Test, L=Test, ST=Test, C=Test";
    private static final String SERVER_DNS_STRING = "CN=localhost, OU=Unknown, L=Unknown, ST=Unknown, C=Unknown";
    private static final String KEYSTORE_PASSWORD = "change.it.12345";

    public static SSLContext createServerSslContext() throws Exception {
        TestSslUtil.setupOnce();
        SecurityFactory ssl = new SSLContextBuilder().setClientMode(false).setKeyManager(TestSslUtil.getKeyManager(SERVER_KEYSTORE_FILE)).setTrustManager(TestSslUtil.getTrustManager()).build();
        return (SSLContext)ssl.create();
    }

    public static SSLContext createClientSslContext() throws Exception {
        TestSslUtil.setupOnce();
        SecurityFactory ssl = new SSLContextBuilder().setClientMode(true).setKeyManager(TestSslUtil.getKeyManager(CLIENT_KEYSTORE_FILE)).setTrustManager(TestSslUtil.getTrustManager()).build();
        return (SSLContext)ssl.create();
    }

    private static void setupOnce() throws Exception {
        if (SETUP.compareAndSet(false, true)) {
            KeyStore clientKeyStore = TestSslUtil.loadKeyStore();
            KeyStore clientTrustStore = TestSslUtil.loadKeyStore();
            KeyStore serverKeyStore = TestSslUtil.loadKeyStore();
            KeyStore serverTrustStore = TestSslUtil.loadKeyStore();
            TestSslUtil.createKeyStoreTrustStore(clientKeyStore, serverTrustStore, CLIENT_DNS_STRING);
            TestSslUtil.createKeyStoreTrustStore(serverKeyStore, clientTrustStore, SERVER_DNS_STRING);
            TestSslUtil.createTemporaryKeyStoreFile(clientKeyStore, CLIENT_KEYSTORE_FILE);
            TestSslUtil.createTemporaryKeyStoreFile(clientTrustStore, CLIENT_TRUSTSTORE_FILE);
            TestSslUtil.createTemporaryKeyStoreFile(serverKeyStore, SERVER_KEYSTORE_FILE);
            TestSslUtil.createTemporaryKeyStoreFile(serverTrustStore, SERVER_TRUSTSTORE_FILE);
        }
    }

    private static X509ExtendedKeyManager getKeyManager(Path ksFile) throws Exception {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(TestSslUtil.loadKeyStore(ksFile), KEYSTORE_PASSWORD.toCharArray());
        for (KeyManager current : keyManagerFactory.getKeyManagers()) {
            if (!(current instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509ExtendedKeyManager.");
    }

    private static X509TrustManager getTrustManager() throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(TestSslUtil.loadKeyStore(CLIENT_TRUSTSTORE_FILE));
        for (TrustManager current : trustManagerFactory.getTrustManagers()) {
            if (!(current instanceof X509TrustManager)) continue;
            return (X509TrustManager)current;
        }
        throw new IllegalStateException("Unable to obtain X509TrustManager.");
    }

    private static KeyStore loadKeyStore(Path ksFile) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        try (InputStream in = Files.newInputStream(ksFile, new OpenOption[0]);){
            ks.load(in, KEYSTORE_PASSWORD.toCharArray());
        }
        return ks;
    }

    private static void createKeyStoreTrustStore(KeyStore keyStore, KeyStore trustStore, String name) throws Exception {
        X500Principal principal = new X500Principal(name);
        SelfSignedX509CertificateAndSigningKey selfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").setDn(principal).setKeySize(2048).build();
        X509Certificate certificate = selfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        keyStore.setKeyEntry(ALIAS, selfSignedX509CertificateAndSigningKey.getSigningKey(), KEYSTORE_PASSWORD.toCharArray(), new X509Certificate[]{certificate});
        trustStore.setCertificateEntry(ALIAS, certificate);
    }

    private static KeyStore loadKeyStore() throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        return ks;
    }

    private static void createTemporaryKeyStoreFile(KeyStore keyStore, Path outputFile) throws Exception {
        try (OutputStream out = Files.newOutputStream(outputFile, StandardOpenOption.CREATE);){
            keyStore.store(out, KEYSTORE_PASSWORD.toCharArray());
        }
    }
}

