/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.SseEventSource;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.plugins.providers.sse.InboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceImpl;
import org.jboss.resteasy.rxjava2.FlowableRxInvoker;
import org.jboss.resteasy.rxjava2.i18n.Messages;

public class FlowableRxInvokerImpl
implements FlowableRxInvoker {
    private static Object monitor = new Object();
    private ClientInvocationBuilder syncInvoker;
    private ScheduledExecutorService executorService;
    private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;

    public FlowableRxInvokerImpl(SyncInvoker syncInvoker, ExecutorService executorService) {
        if (!(syncInvoker instanceof ClientInvocationBuilder)) {
            throw new ProcessingException(Messages.MESSAGES.expectedClientInvocationBuilder(syncInvoker.getClass().getName()));
        }
        this.syncInvoker = (ClientInvocationBuilder)syncInvoker;
        if (executorService instanceof ScheduledExecutorService) {
            this.executorService = (ScheduledExecutorService)executorService;
        }
    }

    public Flowable<?> get() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "GET", null, this.getAccept());
    }

    public <R> Flowable<?> get(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "GET", null, this.getAccept());
    }

    public <R> Flowable<?> get(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "GET", null, this.getAccept());
    }

    public Flowable<?> put(Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "PUT", entity, this.getAccept());
    }

    public <R> Flowable<?> put(Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "PUT", entity, this.getAccept());
    }

    public <R> Flowable<?> put(Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "PUT", entity, this.getAccept());
    }

    public Flowable<?> post(Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "POST", entity, this.getAccept());
    }

    public <R> Flowable<?> post(Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "POST", entity, this.getAccept());
    }

    public <R> Flowable<?> post(Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "POST", entity, this.getAccept());
    }

    public Flowable<?> delete() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "DELETE", null, this.getAccept());
    }

    public <R> Flowable<?> delete(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "DELETE", null, this.getAccept());
    }

    public <R> Flowable<?> delete(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "DELETE", null, this.getAccept());
    }

    public Flowable<?> head() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "HEAD", null, this.getAccept());
    }

    public Flowable<?> options() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "OPTIONS", null, this.getAccept());
    }

    public <R> Flowable<?> options(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "OPTIONS", null, this.getAccept());
    }

    public <R> Flowable<?> options(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "OPTIONS", null, this.getAccept());
    }

    public Flowable<?> trace() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "TRACE", null, this.getAccept());
    }

    public <R> Flowable<?> trace(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "TRACE", null, this.getAccept());
    }

    public <R> Flowable<?> trace(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "TRACE", null, this.getAccept());
    }

    public Flowable<?> method(String name) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, name, null, this.getAccept());
    }

    public <R> Flowable<?> method(String name, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, null, this.getAccept());
    }

    public <R> Flowable<?> method(String name, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, null, this.getAccept());
    }

    public Flowable<?> method(String name, Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, name, entity, this.getAccept());
    }

    public <R> Flowable<?> method(String name, Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, entity, this.getAccept());
    }

    public <R> Flowable<?> method(String name, Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, entity, this.getAccept());
    }

    @Override
    public BackpressureStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }

    @Override
    public void setBackpressureStrategy(BackpressureStrategy backpressureStrategy) {
        this.backpressureStrategy = backpressureStrategy;
    }

    private <T> Flowable<T> eventSourceToObservable(final SseEventSourceImpl sseEventSource, final Class<T> clazz, final String verb, final Entity<?> entity, final MediaType[] mediaTypes) {
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void subscribe(FlowableEmitter<T> emitter) throws Exception {
                sseEventSource.register(e -> {
                    Object t = e.readData(clazz, ((InboundSseEventImpl)e).getMediaType());
                    emitter.onNext(t);
                }, t -> emitter.onError(t), () -> emitter.onComplete());
                Object object = monitor;
                synchronized (object) {
                    if (!sseEventSource.isOpen()) {
                        sseEventSource.open(null, verb, entity, mediaTypes);
                    }
                }
            }
        }, (BackpressureStrategy)this.backpressureStrategy);
        return flowable;
    }

    private <T> Flowable<T> eventSourceToObservable(final SseEventSourceImpl sseEventSource, final GenericType<T> type, final String verb, final Entity<?> entity, final MediaType[] mediaTypes) {
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void subscribe(FlowableEmitter<T> emitter) throws Exception {
                sseEventSource.register(e -> {
                    Object t = e.readData(type, ((InboundSseEventImpl)e).getMediaType());
                    emitter.onNext(t);
                }, t -> emitter.onError(t), () -> emitter.onComplete());
                Object object = monitor;
                synchronized (object) {
                    if (!sseEventSource.isOpen()) {
                        sseEventSource.open(null, verb, entity, mediaTypes);
                    }
                }
            }
        }, (BackpressureStrategy)this.backpressureStrategy);
        return flowable;
    }

    private SseEventSourceImpl getEventSource() {
        SseEventSourceImpl.SourceBuilder builder = (SseEventSourceImpl.SourceBuilder)SseEventSource.target((WebTarget)this.syncInvoker.getTarget());
        if (this.executorService != null) {
            builder.executor(this.executorService);
        }
        SseEventSourceImpl sseEventSource = (SseEventSourceImpl)builder.build();
        sseEventSource.setAlwaysReconnect(false);
        return sseEventSource;
    }

    private MediaType[] getAccept() {
        if (this.syncInvoker instanceof ClientInvocationBuilder) {
            ClientInvocationBuilder builder = this.syncInvoker;
            List accept = builder.getHeaders().getAcceptableMediaTypes();
            return accept.toArray(new MediaType[accept.size()]);
        }
        return null;
    }
}

