/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.embedded.test.core.basic;

import dev.resteasy.junit.extension.annotations.RequestPath;
import dev.resteasy.junit.extension.annotations.RestBootstrap;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Set;
import org.jboss.resteasy.embedded.test.core.basic.resource.ApplicationTestResourceA;
import org.jboss.resteasy.embedded.test.core.basic.resource.ApplicationTestSingletonA;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@RestBootstrap(value=ApplicationTestAExplicitApplication.class)
public class ApplicationExplicitATest {
    @Inject
    private Client client;

    @Test
    @Inject
    public void testExplicitA(@RequestPath(value="/a/explicit") URI uri) {
        WebTarget base = this.client.target(uri);
        String value = (String)base.path("resources/a").request().get(String.class);
        Assertions.assertEquals((Object)"a", (Object)value);
        Response response = base.path("resources/b").request().get();
        Assertions.assertEquals((int)404, (int)response.getStatus());
        value = (String)base.path("singletons/a").request().get(String.class);
        Assertions.assertEquals((Object)"a", (Object)value);
        response = base.path("singletons/b").request().get();
        Assertions.assertEquals((int)404, (int)response.getStatus());
    }

    @ApplicationPath(value="a/explicit")
    public static class ApplicationTestAExplicitApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            return Set.of(ApplicationTestResourceA.class);
        }

        public Set<Object> getSingletons() {
            return Set.of(new ApplicationTestSingletonA());
        }
    }
}

