/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.embedded.test.core.interceptors;

import dev.resteasy.junit.extension.annotations.RequestPath;
import dev.resteasy.junit.extension.annotations.RestBootstrap;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.resteasy.embedded.test.core.interceptors.resource.ReaderContextArrayListEntityProvider;
import org.jboss.resteasy.embedded.test.core.interceptors.resource.ReaderContextFirstReaderInterceptor;
import org.jboss.resteasy.embedded.test.core.interceptors.resource.ReaderContextFirstWriterInterceptor;
import org.jboss.resteasy.embedded.test.core.interceptors.resource.ReaderContextLinkedListEntityProvider;
import org.jboss.resteasy.embedded.test.core.interceptors.resource.ReaderContextResource;
import org.jboss.resteasy.embedded.test.core.interceptors.resource.ReaderContextSecondReaderInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@RestBootstrap(value=TestApplication.class)
public class ReaderContextTest {
    @Inject
    private Client client;

    @Test
    public void readerContextOnClientTest(@RequestPath(value="/resource/poststring") URI uri) {
        this.client = ClientBuilder.newClient();
        WebTarget target = this.client.target(uri);
        target.register(ReaderContextFirstReaderInterceptor.class);
        target.register(ReaderContextSecondReaderInterceptor.class);
        target.register(ReaderContextArrayListEntityProvider.class);
        target.register(ReaderContextLinkedListEntityProvider.class);
        try (Response response = target.request().post(Entity.text((Object)"plaintext"));){
            response.getHeaders().add((Object)"FILTER_HEADER", (Object)ReaderContextFirstReaderInterceptor.class.getName());
            List list = (List)response.readEntity(List.class);
            Assertions.assertInstanceOf(ArrayList.class, (Object)list, (String)"Returned list in not instance of ArrayList");
            String entity = (String)list.get(0);
            Assertions.assertTrue((boolean)entity.contains(ReaderContextSecondReaderInterceptor.class.getName()), (String)"Wrong interceptor type in response");
            Assertions.assertTrue((boolean)entity.contains(ReaderContextSecondReaderInterceptor.class.getAnnotations()[0].annotationType().getName()), (String)"Wrong interceptor annotation in response");
        }
    }

    public static class TestApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            return Set.of(ReaderContextResource.class, ReaderContextArrayListEntityProvider.class, ReaderContextLinkedListEntityProvider.class, ReaderContextFirstReaderInterceptor.class, ReaderContextFirstWriterInterceptor.class, ReaderContextSecondReaderInterceptor.class);
        }
    }
}

