/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.authentication.digest;

import dev.resteasy.client.util.authentication.digest.Algorithm;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class DigestScheme {
    final String realm;
    final String nonce;
    final String opaque;
    final Algorithm algorithm;
    final String qop;
    final boolean stale;
    final AtomicInteger nc;
    final boolean userhash;

    private DigestScheme(String realm, String qop, String nonce, String opaque, Algorithm algorithm, boolean stale, boolean userhash) {
        this.realm = realm;
        this.nonce = nonce;
        this.opaque = opaque;
        this.qop = qop;
        this.algorithm = algorithm;
        this.stale = stale;
        this.nc = new AtomicInteger();
        this.userhash = userhash;
    }

    static DigestScheme of(String headerValue) {
        int i = headerValue.trim().indexOf(32);
        if (i <= 0) {
            return null;
        }
        String challenge = headerValue.substring(i + 1);
        String realm = null;
        String nonce = null;
        String opaque = null;
        String qop = null;
        String algorithm = null;
        boolean stale = false;
        boolean userhash = false;
        Map<String, String> properties = DigestScheme.parse(challenge);
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String key = property.getKey();
            String val = property.getValue();
            if ("qop".equalsIgnoreCase(key)) {
                qop = val;
                continue;
            }
            if ("realm".equalsIgnoreCase(key)) {
                realm = val;
                continue;
            }
            if ("nonce".equalsIgnoreCase(key)) {
                nonce = val;
                continue;
            }
            if ("opaque".equalsIgnoreCase(key)) {
                opaque = val;
                continue;
            }
            if ("stale".equalsIgnoreCase(key)) {
                stale = Boolean.parseBoolean(val);
                continue;
            }
            if ("algorithm".equalsIgnoreCase(key)) {
                algorithm = val;
                continue;
            }
            if (!"userhash".equalsIgnoreCase(key)) continue;
            userhash = Boolean.parseBoolean(val);
        }
        Algorithm parsed = Algorithm.parse(algorithm);
        if (parsed == null) {
            return null;
        }
        return new DigestScheme(realm, qop, nonce, opaque, parsed, stale, userhash);
    }

    private static Map<String, String> parse(String v) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean inKey = true;
        boolean inQuotes = false;
        block6: for (char c : v.toCharArray()) {
            switch (c) {
                case '=': {
                    if (inKey) {
                        inKey = false;
                    }
                    if (!inQuotes) continue block6;
                    value.append(c);
                    continue block6;
                }
                case '\"': {
                    if (inKey) {
                        throw new RuntimeException();
                    }
                    inQuotes = !inQuotes;
                    continue block6;
                }
                case ',': {
                    if (inQuotes) {
                        value.append(c);
                        continue block6;
                    }
                    if (inKey) {
                        throw new RuntimeException();
                    }
                    properties.put(key.toString(), value.toString());
                    inKey = true;
                    key.setLength(0);
                    value.setLength(0);
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!inQuotes) continue block6;
                    value.append(c);
                    continue block6;
                }
                default: {
                    if (inKey) {
                        key.append(c);
                        continue block6;
                    }
                    value.append(c);
                }
            }
        }
        if (key.length() > 0) {
            properties.put(key.toString(), value.toString());
        }
        return properties;
    }
}

