/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.common;

import dev.resteasy.client.util.logging.ClientMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class LimitMap<K, V>
implements Map<K, V> {
    private final Object lock = new Object();
    private final Map<K, V> delegate;

    public LimitMap(final int limit) {
        if (limit < 1) {
            throw ClientMessages.MESSAGES.invalidValue(0, limit);
        }
        this.delegate = new LinkedHashMap<K, V>(limit){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                Object object = LimitMap.this.lock;
                synchronized (object) {
                    return this.size() > limit;
                }
            }
        };
    }

    public static <K, V> LimitMap<K, V> of(int limit) {
        return new LimitMap<K, V>(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.putAll(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Object object = this.lock;
        synchronized (object) {
            return new LinkedHashSet<K>(this.delegate.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<V>(this.delegate.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Object object = this.lock;
        synchronized (object) {
            return new LinkedHashSet<Map.Entry<K, V>>(this.delegate.entrySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimitMap)) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            return Objects.equals(this.delegate, ((LimitMap)o).delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return Objects.hash(this.delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getOrDefault(Object key, V defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.getOrDefault(key, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.forEach(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.replaceAll(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.remove(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.replace(key, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.replace(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.computeIfAbsent((K)key, mappingFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
        }
    }
}

