/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderValueGenerator;

public class ClientHeaderProvider {
    private final Collection<ClientHeaderValueGenerator> generators;

    static Optional<ClientHeaderProvider> forMethod(Method method, Object clientProxy) {
        Class<?> declaringClass = method.getDeclaringClass();
        ClientHeaderParam[] methodAnnotations = (ClientHeaderParam[])method.getAnnotationsByType(ClientHeaderParam.class);
        ClientHeaderParam[] classAnnotations = (ClientHeaderParam[])declaringClass.getAnnotationsByType(ClientHeaderParam.class);
        HashMap<String, ClientHeaderValueGenerator> generators = new HashMap<String, ClientHeaderValueGenerator>();
        for (ClientHeaderParam annotation : methodAnnotations) {
            if (generators.containsKey(annotation.name())) {
                throw new RestClientDefinitionException("Duplicate " + ClientHeaderParam.class.getSimpleName() + " annotation definitions found on " + method.toString());
            }
            generators.put(annotation.name(), new ClientHeaderValueGenerator(annotation, declaringClass, clientProxy));
        }
        ClientHeaderProvider.checkForDuplicateClassLevelAnnotations(classAnnotations, declaringClass);
        Stream.of(classAnnotations).filter(a -> !generators.containsKey(a.name())).forEach(a -> generators.put(a.name(), new ClientHeaderValueGenerator((ClientHeaderParam)a, declaringClass, clientProxy)));
        return generators.isEmpty() ? Optional.empty() : Optional.of(new ClientHeaderProvider(generators.values()));
    }

    private static void checkForDuplicateClassLevelAnnotations(ClientHeaderParam[] classAnnotations, Class<?> declaringClass) {
        HashSet headerNames = new HashSet();
        Arrays.stream(classAnnotations).map(ClientHeaderParam::name).forEach(name -> {
            if (!headerNames.add(name)) {
                throw new RestClientDefinitionException("Duplicate ClientHeaderParam definition for header name " + name + " on class " + declaringClass.getCanonicalName());
            }
        });
    }

    ClientHeaderProvider(Collection<ClientHeaderValueGenerator> generators) {
        this.generators = generators;
    }

    public void addHeaders(MultivaluedMap<String, String> headers) {
        this.generators.forEach(g -> g.fillHeaders(headers));
    }
}

