/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XAttributeSupport;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XWiring;
import org.jboss.osgi.resolver.XWiringSupport;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.jboss.osgi.resolver.spi.AbstractWiringSupport;
import org.jboss.osgi.resolver.spi.AttributeSupporter;
import org.jboss.osgi.resolver.spi.ResourceValidationException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class AbstractResource
extends AbstractElement
implements XResource {
    static List<String> identityNamespaces = Arrays.asList("osgi.identity", "module.identity", "maven.identity");
    private final Map<String, List<Capability>> capabilities = new HashMap<String, List<Capability>>();
    private final Map<String, List<Requirement>> requirements = new HashMap<String, List<Requirement>>();
    private final XAttributeSupport attributes = new AttributeSupporter(null);
    private final AtomicBoolean mutable = new AtomicBoolean(true);
    private final XWiringSupport wiringSupport;
    private XIdentityCapability identityCapability;
    private XResource.State state = XResource.State.UNINSTALLED;

    static AbstractResource assertAbstractResource(XResource resource) {
        assert (resource != null) : "Null resource";
        assert (resource instanceof AbstractResource) : "Not an AbstractResource: " + resource;
        return (AbstractResource)resource;
    }

    public AbstractResource() {
        this.wiringSupport = this.createWiringSupport();
    }

    XWiringSupport createWiringSupport() {
        return new AbstractWiringSupport();
    }

    protected void addCapability(Capability cap) {
        this.ensureMutable();
        String namespace = cap.getNamespace();
        this.getCaplist(namespace).add(cap);
        this.getCaplist(null).add(cap);
        if (identityNamespaces.contains(namespace)) {
            this.identityCapability = (XIdentityCapability)cap;
        }
    }

    protected void addRequirement(Requirement req) {
        this.ensureMutable();
        String namespace = req.getNamespace();
        this.getReqlist(namespace).add(req);
        this.getReqlist(null).add(req);
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map<String, Object> atts = this.attributes.getAttributes();
        return this.isMutable() ? atts : Collections.unmodifiableMap(atts);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public void setMutable(boolean flag) {
        this.mutable.set(flag);
    }

    @Override
    public XResource.State getState() {
        return this.state;
    }

    void setState(XResource.State state) {
        this.state = state;
    }

    @Override
    public boolean isMutable() {
        return this.mutable.get();
    }

    @Override
    public boolean isAbstract() {
        return this.identityCapability != null ? "abstract".equals(this.identityCapability.getType()) : true;
    }

    public void ensureImmutable() {
        if (this.isMutable()) {
            throw ResolverMessages.MESSAGES.illegalStateInvalidAccessToMutableResource();
        }
    }

    public void ensureMutable() {
        if (!this.isMutable()) {
            throw ResolverMessages.MESSAGES.illegalStateInvalidAccessToImmutableResource();
        }
    }

    @Override
    public XWiringSupport getWiringSupport() {
        return this.wiringSupport;
    }

    @Override
    public XWiring getWiring(boolean checkEffective) {
        return this.wiringSupport.getWiring(checkEffective);
    }

    @Override
    public void validate() {
        ArrayList<Capability> icaps = new ArrayList<Capability>();
        icaps.addAll(this.getCaplist("osgi.identity"));
        icaps.addAll(this.getCaplist("module.identity"));
        icaps.addAll(this.getCaplist("maven.identity"));
        if (icaps.size() > 1) {
            throw ResolverMessages.MESSAGES.illegalStateMultipleIdentityCapabilities(icaps);
        }
        if (icaps.size() < 1) {
            throw ResolverMessages.MESSAGES.illegalStateNoIdentityCapability(this);
        }
        XCapability icap = (XCapability)icaps.get(0);
        this.identityCapability = icap.adapt(XIdentityCapability.class);
        for (Capability cap : this.getCaplist(null)) {
            try {
                ((XCapability)cap).validate();
            }
            catch (RuntimeException ex) {
                throw new ResourceValidationException(ResolverMessages.MESSAGES.validationInvalidCapability(cap), (Throwable)ex, cap);
            }
        }
        for (Requirement req : this.getReqlist(null)) {
            try {
                ((XRequirement)req).validate();
            }
            catch (RuntimeException ex) {
                throw new ResourceValidationException(ResolverMessages.MESSAGES.validationInvalidRequirement(req), (Throwable)ex, req);
            }
        }
    }

    public List<Capability> getCapabilities(String namespace) {
        this.ensureImmutable();
        return Collections.unmodifiableList(this.getCaplist(namespace));
    }

    public List<Requirement> getRequirements(String namespace) {
        this.ensureImmutable();
        return Collections.unmodifiableList(this.getReqlist(namespace));
    }

    @Override
    public XIdentityCapability getIdentityCapability() {
        return this.identityCapability;
    }

    private List<Capability> getCaplist(String namespace) {
        List<Capability> caplist = this.capabilities.get(namespace);
        if (caplist == null) {
            caplist = new ArrayList<Capability>();
            this.capabilities.put(namespace, caplist);
        }
        return caplist;
    }

    private List<Requirement> getReqlist(String namespace) {
        List<Requirement> reqlist = this.requirements.get(namespace);
        if (reqlist == null) {
            reqlist = new ArrayList<Requirement>();
            this.requirements.put(namespace, reqlist);
        }
        return reqlist;
    }

    public String toString() {
        XIdentityCapability id = this.identityCapability;
        String idstr = id != null ? id.getName() + ":" + id.getVersion() : "anonymous";
        return this.getClass().getSimpleName() + "[" + idstr + "]";
    }
}

