/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.metadata.VersionRange;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractRequirement;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public class AbstractPackageRequirement
extends AbstractRequirement
implements XPackageRequirement {
    private final String packageName;
    private final VersionRange versionrange;
    private final boolean dynamic;

    public AbstractPackageRequirement(Resource res, Map<String, Object> attrs, Map<String, String> dirs) {
        super(res, "osgi.wiring.package", attrs, dirs);
        this.packageName = (String)attrs.get("osgi.wiring.package");
        Object versionatt = attrs.get("version");
        if (versionatt instanceof String) {
            versionatt = VersionRange.parse((String)((String)versionatt));
        }
        this.versionrange = (VersionRange)versionatt;
        this.dynamic = "dynamic".equals(dirs.get("resolution"));
    }

    @Override
    protected Set<String> getMandatoryAttributes() {
        return Collections.singleton("osgi.wiring.package");
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionrange;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public boolean matchNamespaceValue(XCapability cap) {
        String packageName = this.getPackageName();
        if (packageName.equals("*")) {
            return true;
        }
        XPackageCapability xcap = (XPackageCapability)cap;
        if (packageName.endsWith(".*")) {
            packageName = packageName.substring(0, packageName.length() - 2);
            return xcap.getPackageName().startsWith(packageName);
        }
        return packageName.equals(xcap.getPackageName());
    }

    @Override
    public boolean matches(XCapability cap) {
        Object capval;
        String dirstr;
        String versionstr;
        Version version;
        if (!super.matches(cap)) {
            return false;
        }
        if (this.versionrange != null && !this.versionrange.isInRange(version = ((XPackageCapability)cap).getVersion())) {
            return false;
        }
        HashMap<String, Object> reqatts = new HashMap<String, Object>(this.getAttributes());
        reqatts.remove("osgi.wiring.package");
        reqatts.remove("version");
        reqatts.remove("specification-version");
        HashMap<String, Object> capatts = new HashMap<String, Object>(cap.getAttributes());
        capatts.remove("osgi.wiring.package");
        capatts.remove("version");
        capatts.remove("specification-version");
        String symbolicName = (String)reqatts.remove("bundle-symbolic-name");
        if (symbolicName != null) {
            String targetSymbolicName;
            XResource capres = (XResource)cap.getResource();
            XIdentityCapability idcap = capres.getIdentityCapability();
            String string = targetSymbolicName = idcap != null ? idcap.getSymbolicName() : null;
            if (!symbolicName.equals(targetSymbolicName)) {
                return false;
            }
        }
        if ((versionstr = (String)reqatts.remove("bundle-version")) != null) {
            XResource capres = (XResource)cap.getResource();
            XIdentityCapability idcap = capres.getIdentityCapability();
            Version targetVersion = idcap != null ? idcap.getVersion() : null;
            VersionRange versionRange = VersionRange.parse((String)versionstr);
            if (targetVersion != null && !versionRange.isInRange(targetVersion)) {
                return false;
            }
        }
        if ((dirstr = cap.getDirective("mandatory")) != null) {
            for (String att : dirstr.split(",")) {
                Object reqval;
                capval = capatts.remove(att);
                if (capval == null || capval.equals(reqval = reqatts.remove(att))) continue;
                return false;
            }
        }
        for (Map.Entry entry : reqatts.entrySet()) {
            String att = (String)entry.getKey();
            Object reqval = entry.getValue();
            if (reqval.equals(capval = capatts.remove(att))) continue;
            return false;
        }
        return true;
    }
}

