/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.Provider;

final class ModulesPolicy
extends Policy {
    private static final AllPermission ALL_PERMISSION = new AllPermission();
    static final Permissions DEFAULT_PERMISSION_COLLECTION = ModulesPolicy.getAllPermission();
    private static final CodeSource ourCodeSource = ModulesPolicy.class.getProtectionDomain().getCodeSource();
    private final Policy policy;

    private static Permissions getAllPermission() {
        Permissions permissions = new Permissions();
        permissions.add(ALL_PERMISSION);
        return permissions;
    }

    public ModulesPolicy(Policy policy) {
        this.policy = policy;
    }

    @Override
    public Provider getProvider() {
        return this.policy.getProvider();
    }

    @Override
    public String getType() {
        return this.policy.getType();
    }

    @Override
    public Policy.Parameters getParameters() {
        return this.policy.getParameters();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        return codesource.equals(ourCodeSource) ? ModulesPolicy.getAllPermission() : this.policy.getPermissions(codesource);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        return domain.getCodeSource().equals(ourCodeSource) ? ModulesPolicy.getAllPermission() : this.policy.getPermissions(domain);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        return domain.getCodeSource().equals(ourCodeSource) || this.policy.implies(domain, permission);
    }

    @Override
    public void refresh() {
        this.policy.refresh();
    }
}

