/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.jboss.logging.processor.util.TransformationHelper;

public final class ToolLogger {
    private final Messager messager;
    private final boolean isDebugEnabled;

    private ToolLogger(Messager messager, boolean isDebugEnabled) {
        this.messager = messager;
        this.isDebugEnabled = isDebugEnabled;
    }

    public static ToolLogger getLogger(ProcessingEnvironment processingEnv) {
        String debug = processingEnv.getOptions().get("debug");
        boolean isDebugEnabled = Boolean.parseBoolean(debug);
        return new ToolLogger(processingEnv.getMessager(), isDebugEnabled);
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void note(String messageFormat, Object ... args) {
        this.note(null, messageFormat, args);
    }

    public void note(Element element, String message) {
        this.log(Diagnostic.Kind.NOTE, element, message);
    }

    public void note(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.NOTE, element, messageFormat, args);
    }

    public void debug(String messageFormat, Object ... args) {
        if (this.isDebugEnabled) {
            this.debug(null, messageFormat, args);
        }
    }

    public void debug(Element element, String message) {
        if (this.isDebugEnabled) {
            this.other(element, message);
        }
    }

    public void debug(Element element, String messageFormat, Object ... args) {
        if (this.isDebugEnabled) {
            this.other(messageFormat, element, args);
        }
    }

    public void warn(String messageFormat, Object ... args) {
        this.warn(null, messageFormat, args);
    }

    public void warn(Element element, String message) {
        this.log(Diagnostic.Kind.WARNING, element, message);
    }

    public void warn(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.WARNING, element, messageFormat, args);
    }

    public void mandatoryWarning(String messageFormat, Object ... args) {
        this.mandatoryWarning(null, messageFormat, args);
    }

    public void mandatoryWarning(Element element, String message) {
        this.log(Diagnostic.Kind.MANDATORY_WARNING, element, message);
    }

    public void mandatoryWarning(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.MANDATORY_WARNING, element, messageFormat, args);
    }

    public void error(String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, null, messageFormat, args);
    }

    public void error(Element element, String message) {
        this.log(Diagnostic.Kind.ERROR, element, message);
    }

    public void error(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, element, messageFormat, args);
    }

    public void error(Throwable cause) {
        this.error(null, cause);
    }

    public void error(Throwable cause, Element element, String message) {
        this.log(Diagnostic.Kind.ERROR, element, cause, message);
    }

    public void error(Throwable cause, String messageFormat, Object ... args) {
        this.error(null, cause, messageFormat, args);
    }

    public void error(Element element, Throwable cause) {
        this.log(Diagnostic.Kind.ERROR, element, cause, null);
    }

    public void error(Element element, Throwable cause, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.ERROR, element, cause, messageFormat, args);
    }

    public void other(String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.OTHER, null, messageFormat, args);
    }

    public void other(Element element, String message) {
        this.log(Diagnostic.Kind.OTHER, element, message);
    }

    public void other(Element element, String messageFormat, Object ... args) {
        this.log(Diagnostic.Kind.OTHER, element, messageFormat, args);
    }

    private void log(Diagnostic.Kind kind, Element element, String message) {
        if (element == null) {
            this.messager.printMessage(kind, message);
        } else {
            this.messager.printMessage(kind, message, element);
        }
    }

    private void log(Diagnostic.Kind kind, Element element, String messageFormat, Object ... args) {
        try {
            String message;
            String string = message = args == null || args.length == 0 ? messageFormat : String.format(messageFormat, args);
            if (element == null) {
                this.messager.printMessage(kind, message);
            } else {
                this.messager.printMessage(kind, message, element);
            }
        }
        catch (Throwable t) {
            if (element == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Error logging original message: " + messageFormat);
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Error logging original message: " + messageFormat, element);
        }
    }

    private void log(Diagnostic.Kind kind, Element element, Throwable cause, String messageFormat, Object ... args) {
        String stringCause = TransformationHelper.stackTraceToString(cause);
        if (messageFormat == null) {
            this.log(kind, element, stringCause);
        } else {
            String messageWithCause = messageFormat.concat(", cause : %s");
            ArrayList<Object> newArgs = new ArrayList<Object>();
            newArgs.addAll(Arrays.asList(args));
            newArgs.add(stringCause);
            this.log(kind, element, messageWithCause, newArgs.toArray());
        }
    }

    private void log(Diagnostic.Kind kind, Element element, Throwable cause, String message) {
        String stringCause = TransformationHelper.stackTraceToString(cause);
        if (message == null) {
            this.log(kind, element, stringCause);
        } else {
            String messageWithCause = message.concat(", cause : %s");
            this.log(kind, element, messageWithCause);
        }
    }
}

