/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.plugins.qualifier;

import org.jboss.beans.metadata.api.model.QualifierContent;
import org.jboss.kernel.spi.qualifier.QualifierParser;

/**
 * Handles {@link QualifierContent#STRING}, which is a noop, i.e. no transformation is
 * done on the raw qualifier so the parseXXX() methods return the qualifier in its raw form
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class StringQualifierParser implements QualifierParser
{
   public static StringQualifierParser INSTANCE = new StringQualifierParser();
   
   private StringQualifierParser() {}
   
   public QualifierContent getHandledContent()
   {
      return QualifierContent.STRING;
   }

   public Object parseSupplied(ClassLoader cl, Object rawQualifier)
   {
      return parse(cl, rawQualifier);
   }

   public Object parseWanted(ClassLoader cl, Object rawQualifier)
   {
      return parse(cl, rawQualifier);
   }

   private Object parse(ClassLoader cl, Object rawQualifier)
   {
      return rawQualifier;
   }
}