/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.plugins.dependency;

import java.lang.annotation.Annotation;
import java.util.Set;

import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;

/**
 * Qualifier key.
 *
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @author <a href="ales.justin@jboss.org">Ales Justin</a>
 */
public interface QualifierKey
{
   /**
    * Find matching controller context, null if not found.
    *
    * @param controller the controller
    * @return matching context or null
    */
   ControllerContext search(KernelController controller);

   /**
    * Add qualifiers from annotations.
    *
    * TODO -- is this really needed on this interface?
    *
    * @param annotations the annotations
    */
   void addQualifiersFromAnnotations(Set<Annotation> annotations);
}
