/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

import javax.inject.Inject;

import org.jboss.metadata.spi.MetaData;

/**
 * Singleton Used to filter out which {@link Inject} annotated injection points should not be handled.
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class Jsr330InjectFilter
{
   public static Jsr330InjectFilter INSTANCE = new Jsr330InjectFilter();
   
   Set<Class<? extends Annotation>> ignoredClasses = new HashSet<Class<? extends Annotation>>();
   
   private Jsr330InjectFilter()
   {
   }
   
   /**
    * Add an annotation. If this annotation is present on the injection point we should not handle this inject.
    * 
    * @param annotation an ignored annotation to add
    */
   public void addIgnoredAnnotation(Class<? extends Annotation> annotation)
   {
      ignoredClasses.add(annotation);
   }
   
   /**
    * Check if kernel should handle the injection
    * 
    * @param retrieval The metadata for the injection point we are checking
    * @return true if this injection point should be handled by kernel
    */
   public boolean handleInject(MetaData retrieval)
   {
      for (Annotation ann : retrieval.getAnnotations())
      {
         if (ignoredClasses.contains(ann.annotationType()))
            return false;
      }
      return true;
   }
}
