/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.beans.metadata.spi;

/**
 * Metadata about a property.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 90084 $
 */
public interface PropertyMetaData extends FeatureMetaData
{
   /**
    * Get the name of the property.
    * 
    * @return the name.
    */
   String getName();

   /**
    * Get property type if possible.
    *
    * @return class type if set, otherwise null
    */
   String getType();

   /**
    * Get the preinstantiate flag. Significant for properties taking collection/array/map values.
    * The default is <code>true</code>. When true, if the property getter returns an exisiting value
    * any values in the collection/array/map defined in the deployment description are added to the 
    * exisiting property collection/array/map. If false, the collection/array/map defined in the deployment
    * descriptor overwrites the exisiting property value.
    *
    * @return the preinstantiate flag
    */
   boolean isPreInstantiate();

   /**
    * Get the value the property is being set to.
    * 
    * @return the value.
    */
   ValueMetaData getValue();
}
