/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.beans.metadata.plugins;

import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

import org.jboss.beans.metadata.api.model.QualifierPoint;
import org.jboss.beans.metadata.api.model.QualifierType;
import org.jboss.kernel.plugins.dependency.QualifiersMdrUtil;
import org.jboss.kernel.spi.qualifier.QualifierParser;

/**
 * Qualifier Metadata for a bean's qualifiers
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
@XmlType(name="qualifierType")
public class AbstractBeanQualifierMetaData extends AbstractQualifierMetaData
{
   private static final long serialVersionUID = 1L;
   
   protected QualifierType type = QualifierType.SUPPLIED;

   protected List<QualifierPoint> points;

   public AbstractBeanQualifierMetaData()
   {
      internalSetClassName(QualifiersMdrUtil.SUPPLIED_QUALIFIER_KEY);
   }
   
   /**
    * Get the type
    * @return the type
    */
   public QualifierType getType()
   {
      return type;
   }

   /**
    * Set the type
    * @param type the type
    */
   @XmlAttribute(name="type")
   public void setType(QualifierType type)
   {
      this.type = type;
      if (type == QualifierType.SUPPLIED)
         internalSetClassName(QualifiersMdrUtil.SUPPLIED_QUALIFIER_KEY);
      else if (type == QualifierType.OPTIONAL)
         internalSetClassName(QualifiersMdrUtil.OPTIONAL_QUALIFIER_KEY);
      else if (type == QualifierType.REQUIRED)
         internalSetClassName(QualifiersMdrUtil.REQUIRED_QUALIFIER_KEY);
      else
         throw new IllegalArgumentException("NYI " + type);
   }
   
   /**
    * Set the injection point types this qualifier should be applied to. Null means that it should be applied to all injection point types.
    * @param points the points
    */
   @XmlAttribute(name="points")
   public void setPoints(List<QualifierPoint> points)
   {
      this.points = points;
   }
   
   /**
    * Get the injection point types this qualifier should be applied to. Null means that it should be applied to all injection point types.
    * @return the points
    */
   public List<QualifierPoint> getPoints()
   {
      return points;
   }

   @Override
   protected Object parse(ClassLoader cl, QualifierParser parser, Object enabled)
   {
      if (getType() == QualifierType.SUPPLIED)
         return parser.parseSupplied(cl, enabled);
      else
         return parser.parseWanted(cl, enabled);
   }
}
