/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.logging.Logger;
import org.jboss.util.HashCode;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.propertyeditor.PropertyEditors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="supplyType")
public class AbstractSupplyMetaData
extends JBossObject
implements SupplyMetaData,
Serializable {
    private static final long serialVersionUID = 2L;
    private static Logger log = Logger.getLogger(AbstractSupplyMetaData.class);
    protected Object supply;
    protected String type;

    public AbstractSupplyMetaData() {
    }

    public AbstractSupplyMetaData(Object supply) {
        this.supply = supply;
    }

    @XmlValue
    public void setSupply(Object supply) {
        this.supply = supply;
        this.flushJBossObjectCache();
    }

    public String getType() {
        return this.type;
    }

    @XmlAttribute(name="class")
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Object getSupply() {
        if (this.supply instanceof String && this.type != null) {
            PropertyEditor editor = this.getPropertyEditor();
            editor.setAsText((String)this.supply);
            return editor.getValue();
        }
        return this.supply;
    }

    protected PropertyEditor getPropertyEditor() {
        try {
            return PropertyEditors.getEditor((String)this.type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        Object supply = this.getSupply();
        if (supply == null || supply.toString().length() == 0) {
            throw new IllegalArgumentException("Null or empty supply.");
        }
        visitor.initialVisit(this);
    }

    @Override
    public void describeVisit(MetaDataVisitor vistor) {
        vistor.describeVisit(this);
    }

    @Override
    @XmlTransient
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        return null;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("supply=").append(this.supply);
        if (this.type != null) {
            buffer.append(" class=").append(this.type);
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.supply);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractSupplyMetaData)) {
            return false;
        }
        return AbstractSupplyMetaData.equals((Object)this.supply, (Object)((AbstractSupplyMetaData)obj).supply) && AbstractSupplyMetaData.equals((Object)this.type, (Object)((AbstractSupplyMetaData)obj).type);
    }

    protected int getHashCode() {
        return HashCode.generate((Object)this.supply);
    }

    @Override
    public AbstractSupplyMetaData clone() {
        return (AbstractSupplyMetaData)super.clone();
    }

    static {
        try {
            PropertyEditors.init();
        }
        catch (Throwable t) {
            log.debugf(t, "Unable to initialise property editors", new Object[0]);
        }
    }
}

