/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.spi.qualifier;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.beans.metadata.api.model.QualifierContent;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.plugins.qualifier.AnnotationQualiferParser;
import org.jboss.kernel.plugins.qualifier.DefaultEqualsMatcher;
import org.jboss.kernel.plugins.qualifier.StringQualifierParser;
import org.jboss.kernel.spi.qualifier.QualifierMatcher;
import org.jboss.kernel.spi.qualifier.QualifierParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierMatchers {
    private static final QualifierMatchers SINGLETON = new QualifierMatchers();
    private ConcurrentMap<Class<?>, QualifierMatcher> matchers = new ConcurrentHashMap(3, 0.75f, 1);
    private ConcurrentMap<QualifierContent, QualifierParser> parsers = new ConcurrentHashMap<QualifierContent, QualifierParser>(3, 0.75f, 1);

    private QualifierMatchers() {
        this.addParser(StringQualifierParser.INSTANCE);
        this.addParser(AnnotationQualiferParser.INSTANCE);
    }

    public static QualifierMatchers getInstance() {
        return SINGLETON;
    }

    public QualifierParser getParser(QualifierContent content) {
        QualifierParser parser = (QualifierParser)this.parsers.get(content);
        if (parser == null) {
            throw new IllegalArgumentException("No parser for " + content);
        }
        return parser;
    }

    public boolean matches(ControllerContext context, Set<Object> suppliedQualifiers, Object qualifier) {
        Class<?> clazz = qualifier.getClass();
        QualifierMatcher matcher = null;
        for (Map.Entry entry : this.matchers.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(clazz)) continue;
            matcher = (QualifierMatcher)entry.getValue();
            break;
        }
        if (matcher == null) {
            matcher = DefaultEqualsMatcher.SINGLETON;
        }
        return matcher.matches(context, suppliedQualifiers, qualifier);
    }

    public void addParser(QualifierParser parser) {
        QualifierParser old = this.parsers.putIfAbsent(parser.getHandledContent(), parser);
        if (old != null && old.getClass() != parser.getClass()) {
            throw new IllegalArgumentException(old + " is already handling " + parser.getHandledContent());
        }
    }

    public void removeParser(QualifierContent content) {
        this.parsers.remove(content);
    }

    public void addMatcher(QualifierMatcher matcher) {
        QualifierMatcher old = this.matchers.putIfAbsent(matcher.getHandledType(), matcher);
        if (old != null && old.getClass() != matcher.getClass()) {
            throw new IllegalArgumentException(old + " is already handling " + matcher.getHandledType());
        }
    }

    public void removeMatcher(Class<?> clazz) {
        this.matchers.remove(clazz);
    }
}

