/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.kernel.spi.qualifier;

import java.util.Set;

import org.jboss.dependency.spi.ControllerContext;

/**
 * Abstraction to check if a qualifier exists in a context's set of supplied qualifiers. A QualifierMatcher
 * handles a particular class of wanted qualifier and can check a candidate context and/or its supplied qualifiers
 * to see if the wanted qualifier is satisfied.  
 *
 * @param <T> exact handled type
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public interface QualifierMatcher<T>
{
   /**
    * The class of qualifier handled
    * 
    * @return the class of qualifier handled
    */
   Class<T> getHandledType();
   
   /**
    * Check whether the passed in qualifier matches the context and/or the context's supplied qualifiers
    * 
    * @param context the candidate context to check if matches the passed in qualifier
    * @param suppliedQualifiers the standard supplied qualifiers for thecontext
    * @param qualifier the qualifier to check against the context and/or its qualifiers
    * @return true if there is a match
    */
   boolean matches(ControllerContext context, Set<Object> suppliedQualifiers, T qualifier);
}
