/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.List;

import javax.inject.Qualifier;

import org.jboss.beans.metadata.api.model.QualifierType;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.kernel.plugins.dependency.QualifiersMdrUtil;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.reflect.spi.ClassInfo;

/**
 * Bean annotation plugin.
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class SuppliedQualifierAnnotationPlugin extends ClassAnnotationPlugin<Annotation> implements MetaAnnotationPlugin<ClassInfo, Qualifier>
{
   public static final SuppliedQualifierAnnotationPlugin INSTANCE = new SuppliedQualifierAnnotationPlugin();

   protected SuppliedQualifierAnnotationPlugin()
   {
      super(Annotation.class);
      addTypes(ElementType.TYPE);
   }

   protected boolean isElementTypeSupported(ElementType type)
   {
      return true;
   }
   
   @Override
   protected boolean isCleanup()
   {
      return true;
   }

   @Override
   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, MetaData retrieval, Annotation annotation, KernelControllerContext context) throws Throwable
   {
      if (context != null)
      {
         MetaDataRetrieval instanceMetaData = context.getKernel().getMetaDataRepository().getMetaDataRepository().getMetaDataRetrieval(context.getScopeInfo().getMutableScope());
         QualifiersMdrUtil.addQualifiersToMdrRetrieval(instanceMetaData, QualifierType.SUPPLIED, null, annotation);
      }  

      // we don't put bmd back to be inspected
      // since the changes we apply *here* don't really
      // trigger any change in metadata - all enums
      return null;
   }

   @Override
   protected void internalCleanAnnotation(ClassInfo info, MetaData retrieval, Annotation annotation, KernelControllerContext context) throws Throwable
   {
      if (context != null)
      {
         MetaDataRetrieval instanceMetaData = context.getKernel().getMetaDataRepository().getMetaDataRepository().getMetaDataRetrieval(context.getScopeInfo().getMutableScope());
         QualifiersMdrUtil.removeQualifiersFromMdrRetrieval(instanceMetaData, QualifierType.SUPPLIED, null, annotation);
      }  
   }

   public Class<Qualifier> getMetaAnnotation()
   {
      return Qualifier.class;
   }
}