/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScopedController
extends AbstractController {
    private ScopeKey scopeKey;
    private AbstractController underlyingController;

    @Override
    protected Executor getExecutionEnvironment() {
        Executor executor = super.getExecutionEnvironment();
        if (executor == null && this.getParentController() != null) {
            executor = this.getParentController().getExecutionEnvironment();
        }
        return executor;
    }

    public ScopeKey getScopeKey() {
        return this.scopeKey;
    }

    protected void setScopeKey(ScopeKey scopeKey) {
        this.scopeKey = scopeKey.clone();
        this.scopeKey.freeze();
    }

    protected void setUnderlyingController(AbstractController underlyingController) {
        this.underlyingController = underlyingController;
    }

    @Override
    protected void preAliasInstall(ControllerContext aliasContext) {
        ScopeInfo scopeInfo = aliasContext.getScopeInfo();
        scopeInfo.setInstallScope(this.scopeKey);
    }

    public ControllerContext getContextLocally(Object name, ControllerState state) {
        return super.getContext(name, state);
    }

    protected boolean isScoped() {
        return this.underlyingController != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void addControllerContext(ControllerContext context) {
        if (!this.isScoped()) {
            super.addControllerContext(context);
            return;
        }
        this.lockWrite();
        try {
            try {
                this.underlyingController.removeControllerContext(context);
                context.setController(this);
                context.setRequiredState(this.indexState(context.getRequiredState()));
                this.registerControllerContext(context);
            }
            catch (Throwable t) {
                context.setController(this.underlyingController);
                this.underlyingController.addControllerContext(context);
                context.setRequiredState(this.underlyingController.indexState(context.getRequiredState()));
                if (!(t instanceof RuntimeException)) throw new RuntimeException(t);
                throw (RuntimeException)t;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlockWrite();
            throw throwable;
        }
        this.unlockWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeControllerContext(ControllerContext context) {
        block3: {
            if (this.isScoped()) {
                this.lockWrite();
                try {
                    this.unregisterControllerContext(context);
                    context.setController(this.underlyingController);
                    this.underlyingController.addControllerContext(context);
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.unlockWrite();
                    throw throwable;
                }
                this.unlockWrite();
                {
                    break block3;
                }
            }
            super.removeControllerContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ControllerContext> getInstantiatedContexts(Class<?> clazz) {
        HashSet<ControllerContext> hashSet;
        this.lockRead();
        try {
            Set<ControllerContext> parentContexts;
            AbstractController parentController;
            HashSet<ControllerContext> contexts = new HashSet<ControllerContext>();
            Set<ControllerContext> currentContexts = super.getInstantiatedContexts(clazz);
            if (currentContexts != null && currentContexts.size() > 0) {
                contexts.addAll(currentContexts);
            }
            if ((parentController = this.getParentController()) != null && (parentContexts = parentController.getInstantiatedContexts(clazz)) != null && parentContexts.size() > 0) {
                contexts.addAll(parentContexts);
            }
            hashSet = contexts.size() > 0 ? contexts : null;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.unlockRead();
            throw throwable;
        }
        this.unlockRead();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ControllerContext> getContexts(Class<?> clazz, ControllerState state) {
        HashSet<ControllerContext> hashSet;
        this.lockRead();
        try {
            Set<ControllerContext> parentContexts;
            AbstractController parentController;
            HashSet<ControllerContext> contexts = new HashSet<ControllerContext>();
            Set<ControllerContext> currentContexts = super.getContexts(clazz, state);
            if (currentContexts != null && currentContexts.size() > 0) {
                contexts.addAll(currentContexts);
            }
            if ((parentController = this.getParentController()) != null && (parentContexts = parentController.getContexts(clazz, state)) != null && parentContexts.size() > 0) {
                contexts.addAll(parentContexts);
            }
            hashSet = contexts.size() > 0 ? contexts : null;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.unlockRead();
            throw throwable;
        }
        this.unlockRead();
        return hashSet;
    }

    protected void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append((Object)this.getScopeKey());
    }
}

