package org.jboss.hal.dmr.macro;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class RecordingEvent extends GwtEvent<RecordingEvent.RecordingHandler> { 

  org.jboss.hal.dmr.macro.Action action;
  org.jboss.hal.dmr.macro.MacroOptions options;

  protected RecordingEvent() {
    // Possibly for serialization.
  }

  public RecordingEvent(org.jboss.hal.dmr.macro.Action action, org.jboss.hal.dmr.macro.MacroOptions options) {
    this.action = action;
    this.options = options;
  }

  public static void fire(HasHandlers source, org.jboss.hal.dmr.macro.Action action, org.jboss.hal.dmr.macro.MacroOptions options) {
    RecordingEvent eventInstance = new RecordingEvent(action, options);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, RecordingEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasRecordingHandlers extends HasHandlers {
    HandlerRegistration addRecordingHandler(RecordingHandler handler);
  }

  public interface RecordingHandler extends EventHandler {
    public void onRecording(RecordingEvent event);
  }

  private static final Type<RecordingHandler> TYPE = new Type<RecordingHandler>();

  public static Type<RecordingHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<RecordingHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(RecordingHandler handler) {
    handler.onRecording(this);
  }

  public org.jboss.hal.dmr.macro.Action getAction(){
    return action;
  }

  public org.jboss.hal.dmr.macro.MacroOptions getOptions(){
    return options;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    RecordingEvent other = (RecordingEvent) obj;
    if (action == null) {
      if (other.action != null)
        return false;
    } else if (!action.equals(other.action))
      return false;
    if (options == null) {
      if (other.options != null)
        return false;
    } else if (!options.equals(other.options))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (action == null ? 1 : action.hashCode());
    hashCode = (hashCode * 37) + (options == null ? 1 : options.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "RecordingEvent["
                 + action
                 + ","
                 + options
    + "]";
  }
}
