package org.jboss.hal.core.runtime.server;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.web.bindery.event.shared.HandlerRegistration;

import com.google.gwt.event.shared.HasHandlers;

public class ServerActionEvent extends GwtEvent<ServerActionEvent.ServerActionHandler> { 

  org.jboss.hal.core.runtime.server.Server server;
  org.jboss.hal.core.runtime.Action action;

  protected ServerActionEvent() {
    // Possibly for serialization.
  }

  public ServerActionEvent(org.jboss.hal.core.runtime.server.Server server, org.jboss.hal.core.runtime.Action action) {
    this.server = server;
    this.action = action;
  }

  public static void fire(HasHandlers source, org.jboss.hal.core.runtime.server.Server server, org.jboss.hal.core.runtime.Action action) {
    ServerActionEvent eventInstance = new ServerActionEvent(server, action);
    source.fireEvent(eventInstance);
  }

  public static void fire(HasHandlers source, ServerActionEvent eventInstance) {
    source.fireEvent(eventInstance);
  }

  public interface HasServerActionHandlers extends HasHandlers {
    HandlerRegistration addServerActionHandler(ServerActionHandler handler);
  }

  public interface ServerActionHandler extends EventHandler {
    public void onServerAction(ServerActionEvent event);
  }

  private static final Type<ServerActionHandler> TYPE = new Type<ServerActionHandler>();

  public static Type<ServerActionHandler> getType() {
    return TYPE;
  }

  @Override
  public Type<ServerActionHandler> getAssociatedType() {
    return TYPE;
  }

  @Override
  protected void dispatch(ServerActionHandler handler) {
    handler.onServerAction(this);
  }

  public org.jboss.hal.core.runtime.server.Server getServer(){
    return server;
  }

  public org.jboss.hal.core.runtime.Action getAction(){
    return action;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
        return true;
    if (obj == null)
        return false;
    if (getClass() != obj.getClass())
        return false;
    ServerActionEvent other = (ServerActionEvent) obj;
    if (server == null) {
      if (other.server != null)
        return false;
    } else if (!server.equals(other.server))
      return false;
    if (action == null) {
      if (other.action != null)
        return false;
    } else if (!action.equals(other.action))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 23;
    hashCode = (hashCode * 37) + (server == null ? 1 : server.hashCode());
    hashCode = (hashCode * 37) + (action == null ? 1 : action.hashCode());
    return hashCode;
  }

  @Override
  public String toString() {
    return "ServerActionEvent["
                 + server
                 + ","
                 + action
    + "]";
  }
}
