package org.jboss.hal.client.configuration.subsystem.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.ExpressionUtil;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_BatchView extends BatchView {

    private final Metadata metadata17;
    private final Metadata metadata16;
    private final Metadata metadata13;
    private final Metadata metadata15;
    private final Metadata metadata14;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_BatchView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata17Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-pool=*");
        this.metadata17 = mbuiContext.metadataRegistry().lookup(metadata17Template);
        AddressTemplate metadata16Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*");
        this.metadata16 = mbuiContext.metadataRegistry().lookup(metadata16Template);
        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/jdbc-job-repository=*");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/in-memory-job-repository=*");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("batch-configuration-form", metadata13)
            .onSave((form, changedValues) -> saveSingletonForm("Subsystem", metadata13Template.resolve(statementContext()), changedValues, metadata13))
            .prepareReset(form -> resetSingletonForm("Subsystem", metadata13Template.resolve(statementContext()), form, metadata13))
            .build();
        jdbcJobRepoForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-form", metadata15)
            .include("data-source")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JDBC Job Repository", name, metadata15Template.resolve(statementContext(), name), changedValues, metadata15);
            })
            .build();
        jdbcJobRepoForm.getFormItem("data-source").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=datasources/data-source=*")));
        threadFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-form", metadata16)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Factory", name, metadata16Template.resolve(statementContext(), name), changedValues, metadata16);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Factory", name, metadata16Template.resolve(statementContext(), name), form, metadata16);
            })
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-form", metadata17)
            .include("name", "max-threads", "thread-factory")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata17Template.resolve(statementContext(), name), changedValues, metadata17);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata17Template.resolve(statementContext(), name), form, metadata17);
            })
            .build();
        threadPoolForm.getFormItem("thread-factory").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=batch-jberet/thread-factory=*")));

        inMemoryJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-in-memory-job-repo-table", metadata14)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-in-memory-job-repo-table", Ids.ADD), "In Memory Job",
                metadata14Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("In Memory Job", metadata14Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        jdbcJobRepoTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-jdbc-job-repo-table", metadata15)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-jdbc-job-repo-table", Ids.ADD), "JDBC Job Repository",
                metadata15Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JDBC Job Repository", metadata15Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-factory-table", metadata16)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-factory-table", Ids.ADD), "Thread Factory",
                metadata16Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Factory", metadata16Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("batch-thread-pool-table", metadata17)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("batch-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata17Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata17Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html40;
        HTMLElement batchConfigurationItemElement = section()
            .add(html40 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata13.getDescription().getDescription()}</p>"))
                            .element())
            .add(configurationForm)
                    .element();
        expressionElements.put("html40", html40);
        navigation.addPrimary("batch-configuration-item", "Configuration", "pficon pficon-settings", batchConfigurationItemElement);
        HTMLElement html42;
        HTMLElement batchInMemoryJobRepoItemElement = section()
            .add(html42 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In Memory Job Repository</h1><p>${metadata14.getDescription().getDescription()}</p>"))
                            .element())
            .add(inMemoryJobRepoTable)
                    .element();
        expressionElements.put("html42", html42);
        navigation.addPrimary("batch-in-memory-job-repo-item", "In Memory", "pficon pficon-memory", batchInMemoryJobRepoItemElement);
        HTMLElement html44;
        HTMLElement batchJdbcJobRepoItemElement = section()
            .add(html44 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JDBC Job Repository</h1><p>${metadata15.getDescription().getDescription()}</p>"))
                            .element())
            .add(jdbcJobRepoTable)
            .add(jdbcJobRepoForm)
                    .element();
        expressionElements.put("html44", html44);
        navigation.addPrimary("batch-jdbc-job-repo-item", "JDBC", "fa fa-database", batchJdbcJobRepoItemElement);
        HTMLElement html47;
        HTMLElement batchThreadFactoryItemElement = section()
            .add(html47 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Factory</h1><p>${metadata16.getDescription().getDescription()}</p>"))
                            .element())
            .add(threadFactoryTable)
            .add(threadFactoryForm)
                    .element();
        expressionElements.put("html47", html47);
        navigation.addPrimary("batch-thread-factory-item", "Thread Factory", "pficon pficon-service", batchThreadFactoryItemElement);
        HTMLElement html50;
        HTMLElement batchThreadPoolItemElement = section()
            .add(html50 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata17.getDescription().getDescription()}</p>"))
                            .element())
            .add(threadPoolTable)
            .add(threadPoolForm)
                    .element();
        expressionElements.put("html50", html50);
        navigation.addPrimary("batch-thread-pool-item", "Thread Pool", "pficon pficon-resource-pool", batchThreadPoolItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .element();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(inMemoryJobRepoTable);
        registerAttachable(jdbcJobRepoTable);
        registerAttachable(jdbcJobRepoForm);
        registerAttachable(threadFactoryTable);
        registerAttachable(threadFactoryForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            jdbcJobRepoTable.bindForm(jdbcJobRepoForm);
            threadFactoryTable.bindForm(threadFactoryForm);
            threadPoolTable.bindForm(threadPoolForm);

        ExpressionUtil.replaceExpression(expressionElements.get("html40"), "${metadata13.getDescription().getDescription()}", String.valueOf(metadata13.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html42"), "${metadata14.getDescription().getDescription()}", String.valueOf(metadata14.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html44"), "${metadata15.getDescription().getDescription()}", String.valueOf(metadata15.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html47"), "${metadata16.getDescription().getDescription()}", String.valueOf(metadata16.getDescription().getDescription()));
        ExpressionUtil.replaceExpression(expressionElements.get("html50"), "${metadata17.getDescription().getDescription()}", String.valueOf(metadata17.getDescription().getDescription()));
    }
}
